/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.wizard;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.config.ApplicationObjectConfigurer;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.wizard.Wizard;
import org.springframework.richclient.wizard.WizardDialog;
import org.springframework.richclient.wizard.WizardPage;

public class ExtendedWizardDialog
extends WizardDialog {
    private Map<String, Component> indexComponents = new HashMap<String, Component>();
    private Map<String, Component> indexNumbers = new HashMap<String, Component>();
    private JLabel stepNofMax = new JLabel();
    private String id = null;

    public ExtendedWizardDialog() {
    }

    public ExtendedWizardDialog(Wizard wizard) {
        this(wizard, null);
    }

    public ExtendedWizardDialog(Wizard wizard, String id) {
        super(wizard);
        this.id = id;
        if (this.id != null) {
            ((ApplicationObjectConfigurer)ApplicationServicesLocator.services().getService(ApplicationObjectConfigurer.class)).configure(this, this.id);
        }
    }

    public void setWizard(Wizard wizard) {
        super.setWizard(wizard);
        this.wizard = wizard;
    }

    protected JComponent createDialogContentPane() {
        JPanel wizardPanel = new JPanel((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 0.0), ColumnSpec.decode((String)"fill:pref"), new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 1.0), RowSpec.decode((String)"fill:pref")}));
        CellConstraints cc = new CellConstraints();
        wizardPanel.add((Component)new JSeparator(1), cc.xy(2, 1));
        wizardPanel.add((Component)super.createDialogContentPane(), cc.xy(3, 1));
        wizardPanel.add(this.createWizardIndex(), cc.xy(1, 1));
        wizardPanel.add((Component)new JSeparator(), cc.xyw(1, 2, 3));
        return wizardPanel;
    }

    private Component createWizardIndex() {
        JPanel indexPanel = new JPanel((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.CENTER, (Size)Sizes.DEFAULT, 0.0)}, new RowSpec[]{new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, (Size)Sizes.DEFAULT, 1.0), FormFactory.UNRELATED_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, (Size)Sizes.DEFAULT, 0.0)}));
        CellConstraints cc = new CellConstraints();
        GuiStandardUtils.attachBorder(indexPanel, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        indexPanel.add((Component)this.createWizardTitle(), cc.xy(1, 1));
        WizardPage[] pages = this.wizard.getPages();
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("right:pref, 3dlu, left:pref", ""));
        for (int i = 0; i < pages.length; ++i) {
            JLabel indexNumber = new JLabel(Integer.toString(i + 1) + ".");
            indexNumber.setName(Integer.toString(i + 1));
            JLabel indexTitle = new JLabel(pages[i].getTitle());
            this.indexNumbers.put(pages[i].getTitle(), indexNumber);
            this.indexComponents.put(pages[i].getTitle(), indexTitle);
            builder.append((Component)indexNumber);
            builder.append((Component)indexTitle);
            if (i >= pages.length - 1) continue;
            builder.nextLine();
        }
        indexPanel.add((Component)builder.getPanel(), cc.xy(1, 3));
        indexPanel.add(this.createStepNofMPanel(pages.length), cc.xy(1, 5));
        return indexPanel;
    }

    private JLabel createWizardTitle() {
        return new JLabel(this.getTitle());
    }

    private Component createStepNofMPanel(int m) {
        JPanel panel = new JPanel((LayoutManager)new FormLayout("fill:pref, fill:pref:grow, fill:pref", "center:pref:none"));
        CellConstraints cc = new CellConstraints();
        panel.add((Component)new JLabel("Stap "), cc.xy(1, 1));
        panel.add((Component)this.stepNofMax, cc.xy(2, 1));
        panel.add((Component)new JLabel(" van " + Integer.toString(m)), cc.xy(3, 1));
        return panel;
    }

    public void showPage(WizardPage page) {
        JComponent component;
        String pageTitle;
        if (this.getCurrentPage() != null) {
            pageTitle = this.getCurrentPage().getTitle();
            component = (JComponent)this.indexComponents.get(pageTitle);
            component.setFont(component.getFont().deriveFont(0));
            component = (JComponent)this.indexNumbers.get(pageTitle);
            component.setFont(component.getFont().deriveFont(0));
        }
        super.showPage(page);
        pageTitle = page.getTitle();
        component = (JComponent)this.indexComponents.get(pageTitle);
        component.setFont(component.getFont().deriveFont(1));
        component = (JComponent)this.indexNumbers.get(pageTitle);
        component.setFont(component.getFont().deriveFont(1));
        this.stepNofMax.setText(component.getName());
    }
}

