/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.wizard;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.dialog.TitledApplicationDialog;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.richclient.wizard.Wizard;
import org.springframework.richclient.wizard.WizardContainer;
import org.springframework.richclient.wizard.WizardPage;
import org.springframework.util.Assert;

public class WizardDialog
extends TitledApplicationDialog
implements WizardContainer,
PropertyChangeListener {
    protected Wizard wizard;
    protected ActionCommand nextCommand;
    protected ActionCommand backCommand;
    protected WizardPage currentPage;
    protected int largestPageWidth;
    protected int largestPageHeight;

    public WizardDialog() {
        this(null);
    }

    public WizardDialog(Wizard wizard) {
        this.setWizard(wizard);
        this.setResizable(true);
    }

    public void setWizard(Wizard wizard) {
        if (this.wizard != wizard) {
            if (this.wizard != null) {
                this.wizard.setContainer(null);
            }
            this.wizard = wizard;
            if (this.wizard != null) {
                this.wizard.setContainer(this);
                this.setTitle(wizard.getTitle());
                this.wizard.addPages();
            }
        }
    }

    protected String getFinishCommandId() {
        return "finishCommand";
    }

    protected JComponent createTitledDialogContentPane() {
        this.createPageControls();
        WizardPage startPage = this.wizard.getStartingPage();
        Assert.notNull((Object)startPage, (String)"No starting page returned; unable to show wizard.");
        JComponent control = startPage.getControl();
        if (this.getPreferredSize() == null) {
            control.setPreferredSize(this.getLargestPageSize());
        }
        return control;
    }

    private Dimension getLargestPageSize() {
        return new Dimension(this.largestPageWidth + 5, this.largestPageHeight + 5);
    }

    protected Object[] getCommandGroupMembers() {
        if (!this.wizard.needsPreviousAndNextButtons()) {
            return super.getCommandGroupMembers();
        }
        this.nextCommand = new ActionCommand("nextCommand"){

            public void doExecuteCommand() {
                WizardDialog.this.onNext();
            }
        };
        this.backCommand = new ActionCommand("backCommand"){

            public void doExecuteCommand() {
                WizardDialog.this.onBack();
            }
        };
        this.backCommand.setEnabled(false);
        return new AbstractCommand[]{this.backCommand, this.nextCommand, this.getFinishCommand(), this.getCancelCommand()};
    }

    protected void onAboutToShow() {
        this.showPage(this.wizard.getStartingPage());
        super.onAboutToShow();
    }

    private void createPageControls() {
        WizardPage[] pages = this.wizard.getPages();
        for (int i = 0; i < pages.length; ++i) {
            JComponent c = pages[i].getControl();
            GuiStandardUtils.attachDialogBorder(c);
            Dimension size = c.getPreferredSize();
            if (size.width > this.largestPageWidth) {
                this.largestPageWidth = size.width;
            }
            if (size.height <= this.largestPageHeight) continue;
            this.largestPageHeight = size.height;
        }
    }

    public void showPage(WizardPage page) {
        if (this.currentPage != page) {
            if (this.currentPage != null) {
                this.currentPage.removePropertyChangeListener(this);
            }
            this.currentPage = page;
            this.currentPage.addPropertyChangeListener(this);
            this.updateDialog();
            this.setContentPane(page.getControl());
        }
        this.currentPage.onAboutToShow();
        this.currentPage.setVisible(true);
    }

    public WizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected void onBack() {
        WizardPage newPage = this.currentPage.getPreviousPage();
        if (newPage == null || newPage == this.currentPage) {
            throw new IllegalStateException("No such page.");
        }
        this.showPage(newPage);
    }

    protected void onNext() {
        WizardPage newPage = this.currentPage.getNextPage();
        if (newPage == null || newPage == this.currentPage) {
            throw new IllegalStateException("No such page.");
        }
        this.showPage(newPage);
    }

    protected boolean onFinish() {
        return this.wizard.performFinish();
    }

    protected void onCancel() {
        if (this.wizard.performCancel()) {
            super.onCancel();
        }
    }

    protected void updateDialog() {
        if (!this.isControlCreated()) {
            throw new IllegalStateException("Container controls not initialized - update not allowed.");
        }
        this.updateTitlePane();
        this.updateMessagePane();
        this.updateButtons();
    }

    protected void updateTitlePane() {
        this.setTitlePaneTitle(this.currentPage.getTitle());
        this.setTitlePaneImage(this.currentPage.getImage());
        this.setDescription(this.currentPage.getDescription());
    }

    protected void updateMessagePane() {
        this.setMessage(this.currentPage.getMessage());
    }

    private void updateButtons() {
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.backCommand.setEnabled(this.currentPage.getPreviousPage() != null);
            this.nextCommand.setEnabled(this.canFlipToNextPage());
        }
        this.setFinishEnabled(this.wizard.canFinish());
        if (this.canFlipToNextPage() && !this.wizard.canFinish()) {
            this.registerDefaultCommand(this.nextCommand);
        } else {
            this.registerDefaultCommand();
        }
    }

    private boolean canFlipToNextPage() {
        return this.currentPage.canFlipToNextPage();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("message".equals(e.getPropertyName())) {
            this.updateMessagePane();
        } else if ("pageComplete".equals(e.getPropertyName())) {
            this.updateButtons();
        } else if ("description".equals(e.getPropertyName())) {
            this.updateTitlePane();
        }
    }
}

