/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.closure.support;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.style.ToStringCreator;
import org.springframework.rules.closure.Closure;

public class ClosureChain
implements Closure {
    private Set closures = new LinkedHashSet();

    public ClosureChain() {
    }

    public ClosureChain(Closure function1, Closure function2) {
        this.closures.add(function1);
        this.closures.add(function2);
    }

    public ClosureChain(Closure[] functions) {
        this.closures.addAll(Arrays.asList(functions));
    }

    public ClosureChain add(Closure function) {
        this.closures.add(function);
        return this;
    }

    public Iterator iterator() {
        return this.closures.iterator();
    }

    public Object call(Object argument) {
        Object result = argument;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Closure f = (Closure)it.next();
            result = f.call(result);
        }
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("closureChain", (Object)this.closures).toString();
    }
}

