/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import org.springframework.rules.closure.Closure;
import org.springframework.rules.constraint.Constraint;
import org.springframework.util.Assert;

public class ClosureResultConstraint
implements Constraint {
    private Constraint constraint;
    private Closure closure;

    public ClosureResultConstraint(Closure closure, Constraint constraint) {
        Assert.notNull((Object)closure, (String)"closure is required");
        Assert.notNull((Object)constraint, (String)"constraint is required");
        this.constraint = constraint;
        this.closure = closure;
    }

    public boolean test(Object argument) {
        Object returnValue = this.closure.call(argument);
        return this.constraint.test(returnValue);
    }

    public Closure getFunction() {
        return this.closure;
    }

    public Constraint getPredicate() {
        return this.constraint;
    }

    public String toString() {
        return "[" + this.closure.toString() + " " + this.constraint.toString() + "]";
    }
}

