/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.binding.support.BeanPropertyAccessStrategy;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.util.Assert;

public abstract class AbstractPropertyConstraint
implements PropertyConstraint {
    private String propertyName;

    protected AbstractPropertyConstraint() {
    }

    protected AbstractPropertyConstraint(String propertyName) {
        this.setPropertyName(propertyName);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isDependentOn(String propertyName) {
        return this.getPropertyName().equals(propertyName);
    }

    public boolean isCompoundRule() {
        return false;
    }

    protected void setPropertyName(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"The propertyName to constrain is required");
        this.propertyName = propertyName;
    }

    public boolean test(Object o) {
        if (o instanceof PropertyAccessStrategy) {
            return this.test((PropertyAccessStrategy)o);
        }
        return this.test(new BeanPropertyAccessStrategy(o));
    }

    protected abstract boolean test(PropertyAccessStrategy var1);

    public String toString() {
        return this.getPropertyName();
    }
}

