/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.rules.constraint.CompoundConstraint;
import org.springframework.rules.constraint.LogicalOperator;
import org.springframework.rules.constraint.property.CompoundPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyPresent;
import org.springframework.rules.constraint.property.RequiredIfTrue;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RequiredIfOthersPresent
extends RequiredIfTrue {
    public RequiredIfOthersPresent(String propertyName, String[] otherPropertyNames) {
        this(propertyName, otherPropertyNames, LogicalOperator.AND);
    }

    public RequiredIfOthersPresent(String propertyName, String[] otherPropertyNames, LogicalOperator operator) {
        super(propertyName);
        Assert.notNull((Object)otherPropertyNames, (String)"otherPropertyNames is required");
        Assert.notNull((Object)((Object)operator), (String)"operator is required");
        Assert.notEmpty((Object[])otherPropertyNames, (String)"otherPropertyNames must consist of at least one name");
        CompoundConstraint compoundConstraint = operator.createConstraint();
        CompoundPropertyConstraint propertyConstraint = new CompoundPropertyConstraint(compoundConstraint);
        for (int i = 0; i < otherPropertyNames.length; ++i) {
            propertyConstraint.add(new PropertyPresent(otherPropertyNames[i]));
        }
        this.setConstraint(propertyConstraint);
    }

    public RequiredIfOthersPresent(String propertyName, String otherPropertyNames) {
        this(propertyName, otherPropertyNames, LogicalOperator.AND);
    }

    public RequiredIfOthersPresent(String propertyName, String otherPropertyNames, LogicalOperator operator) {
        this(propertyName, StringUtils.commaDelimitedListToStringArray((String)otherPropertyNames), operator);
    }

    public boolean isDependentOn(String propertyName) {
        return this.getPropertyName().equals(propertyName) || ((CompoundPropertyConstraint)this.getConstraint()).isDependentOn(propertyName);
    }

    public boolean isCompoundRule() {
        return true;
    }
}

