/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.Required;
import org.springframework.rules.constraint.property.AbstractPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.util.Assert;

public class RequiredIfTrue
extends AbstractPropertyConstraint {
    private Constraint constraint;

    public RequiredIfTrue(String propertyName, Constraint predicate) {
        super(propertyName);
        this.setConstraint(predicate);
    }

    protected RequiredIfTrue(String propertyName) {
        super(propertyName);
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    protected void setConstraint(Constraint predicate) {
        Assert.notNull((Object)predicate, (String)"predicate is required");
        this.constraint = predicate;
    }

    public boolean isDependentOn(String propertyName) {
        boolean dependent = false;
        if (this.getConstraint() instanceof PropertyConstraint) {
            dependent = ((PropertyConstraint)this.getConstraint()).isDependentOn(propertyName);
        }
        return super.isDependentOn(propertyName) || dependent;
    }

    protected boolean test(PropertyAccessStrategy domainObjectAccessStrategy) {
        if (this.constraint.test(domainObjectAccessStrategy)) {
            return Required.instance().test(domainObjectAccessStrategy.getPropertyValue(this.getPropertyName()));
        }
        return true;
    }

    public String toString() {
        return "required if (" + this.constraint + ")";
    }
}

