/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.factory;

import java.util.Comparator;
import java.util.Set;
import org.springframework.rules.closure.BinaryConstraint;
import org.springframework.rules.closure.Closure;
import org.springframework.rules.closure.support.AlgorithmsAccessor;
import org.springframework.rules.constraint.And;
import org.springframework.rules.constraint.ClosureResultConstraint;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.EqualTo;
import org.springframework.rules.constraint.GreaterThan;
import org.springframework.rules.constraint.GreaterThanEqualTo;
import org.springframework.rules.constraint.IfTrue;
import org.springframework.rules.constraint.InGroup;
import org.springframework.rules.constraint.LessThan;
import org.springframework.rules.constraint.LessThanEqualTo;
import org.springframework.rules.constraint.Like;
import org.springframework.rules.constraint.MethodInvokingConstraint;
import org.springframework.rules.constraint.Not;
import org.springframework.rules.constraint.Or;
import org.springframework.rules.constraint.ParameterizedBinaryConstraint;
import org.springframework.rules.constraint.Range;
import org.springframework.rules.constraint.RegexpConstraint;
import org.springframework.rules.constraint.RelationalOperator;
import org.springframework.rules.constraint.Required;
import org.springframework.rules.constraint.StringLengthConstraint;
import org.springframework.rules.constraint.XOr;
import org.springframework.rules.constraint.property.CompoundPropertyConstraint;
import org.springframework.rules.constraint.property.ConditionalPropertyConstraint;
import org.springframework.rules.constraint.property.NegatedPropertyConstraint;
import org.springframework.rules.constraint.property.ParameterizedPropertyConstraint;
import org.springframework.rules.constraint.property.PropertiesConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.constraint.property.PropertyValueConstraint;
import org.springframework.rules.constraint.property.UniquePropertyValueConstraint;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Constraints
extends AlgorithmsAccessor {
    private static Constraints INSTANCE = new Constraints();

    public static Constraints instance() {
        return INSTANCE;
    }

    public static void load(Constraints sharedInstance) {
        Assert.notNull((Object)sharedInstance, (String)"The global constraints factory cannot be null");
        INSTANCE = sharedInstance;
    }

    public Constraint bind(BinaryConstraint constraint, Object parameter) {
        return new ParameterizedBinaryConstraint(constraint, parameter);
    }

    public Constraint bind(BinaryConstraint constraint, int parameter) {
        return new ParameterizedBinaryConstraint(constraint, parameter);
    }

    public Constraint bind(BinaryConstraint constraint, float parameter) {
        return new ParameterizedBinaryConstraint(constraint, parameter);
    }

    public Constraint bind(BinaryConstraint constraint, double parameter) {
        return new ParameterizedBinaryConstraint(constraint, parameter);
    }

    public Constraint bind(BinaryConstraint constraint, boolean parameter) {
        return new ParameterizedBinaryConstraint(constraint, parameter);
    }

    public Constraint testResultOf(Closure closure, Constraint constraint) {
        return new ClosureResultConstraint(closure, constraint);
    }

    public Constraint eq(Object value) {
        return EqualTo.value(value);
    }

    public Constraint eq(int value) {
        return this.eq(new Integer(value));
    }

    public Constraint eq(Object value, Comparator comparator) {
        return EqualTo.value(value, comparator);
    }

    public Constraint gt(Comparable value) {
        return GreaterThan.value(value);
    }

    public Constraint gt(Object value, Comparator comparator) {
        return GreaterThan.value(value, comparator);
    }

    public Constraint gt(int value) {
        return this.gt(new Integer(value));
    }

    public Constraint gt(long value) {
        return this.gt(new Long(value));
    }

    public Constraint gt(float value) {
        return this.gt(new Float(value));
    }

    public Constraint gt(double value) {
        return this.gt(new Double(value));
    }

    public Constraint gte(Comparable value) {
        return GreaterThanEqualTo.value(value);
    }

    public Constraint gte(Object value, Comparator comparator) {
        return GreaterThanEqualTo.value(value, comparator);
    }

    public Constraint gte(int value) {
        return this.gte(new Integer(value));
    }

    public Constraint gte(long value) {
        return this.gte(new Long(value));
    }

    public Constraint gte(float value) {
        return this.gte(new Float(value));
    }

    public Constraint gte(double value) {
        return this.gte(new Double(value));
    }

    public Constraint lt(Comparable value) {
        return LessThan.value(value);
    }

    public Constraint lt(Comparable value, Comparator comparator) {
        return LessThan.value(value, comparator);
    }

    public Constraint lt(int value) {
        return this.lt(new Integer(value));
    }

    public Constraint lt(long value) {
        return this.lt(new Long(value));
    }

    public Constraint lt(float value) {
        return this.lt(new Float(value));
    }

    public Constraint lt(double value) {
        return this.lt(new Double(value));
    }

    public Constraint lte(Comparable value) {
        return LessThanEqualTo.value(value);
    }

    public Constraint lte(Object value, Comparator comparator) {
        return LessThanEqualTo.value(value, comparator);
    }

    public Constraint lte(int value) {
        return this.lte(new Integer(value));
    }

    public Constraint lte(long value) {
        return this.lte(new Long(value));
    }

    public Constraint lte(float value) {
        return this.lte(new Float(value));
    }

    public Constraint lte(double value) {
        return this.lte(new Double(value));
    }

    public Constraint range(Comparable min, Comparable max) {
        return new Range(min, max);
    }

    public Constraint range(Comparable min, Comparable max, boolean inclusive) {
        return new Range(min, max, inclusive);
    }

    public Constraint range(Object min, Object max, Comparator comparator) {
        return new Range(min, max, comparator);
    }

    public Constraint range(Object min, Object max, Comparator comparator, boolean inclusive) {
        return new Range(min, max, comparator, inclusive);
    }

    public Constraint range(int min, int max) {
        return new Range(min, max);
    }

    public Constraint range(long min, long max) {
        return new Range(min, max);
    }

    public Constraint range(float min, float max) {
        return new Range(min, max);
    }

    public Constraint range(double min, double max) {
        return new Range(min, max);
    }

    public Constraint present() {
        return Required.present();
    }

    public Constraint required() {
        return Required.instance();
    }

    public Constraint ifTrue(Constraint constraint, Constraint mustAlsoBeTrue) {
        return new IfTrue(constraint, mustAlsoBeTrue);
    }

    public Constraint ifTrue(Constraint constraint, Constraint mustAlsoBeTrue, Constraint elseMustAlsoBeTrue) {
        return new IfTrue(constraint, mustAlsoBeTrue, elseMustAlsoBeTrue);
    }

    public Constraint ifTrue(Constraint constraint, Constraint mustAlsoBeTrue, String type) {
        return new IfTrue(constraint, mustAlsoBeTrue, type);
    }

    public Constraint ifTrue(Constraint constraint, Constraint mustAlsoBeTrue, Constraint elseMustAlsoBeTrue, String type) {
        return new IfTrue(constraint, mustAlsoBeTrue, elseMustAlsoBeTrue, type);
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint) {
        return new ConditionalPropertyConstraint(ifConstraint, thenConstraint);
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint, String type) {
        return new ConditionalPropertyConstraint(ifConstraint, thenConstraint, type);
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint, PropertyConstraint elseConstraint) {
        return new ConditionalPropertyConstraint(ifConstraint, thenConstraint, elseConstraint);
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint thenConstraint, PropertyConstraint elseConstraint, String type) {
        return new ConditionalPropertyConstraint(ifConstraint, thenConstraint, elseConstraint, type);
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint[] thenConstraints) {
        return new ConditionalPropertyConstraint(ifConstraint, new CompoundPropertyConstraint(new And(thenConstraints)));
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint[] thenConstraints, String type) {
        return new ConditionalPropertyConstraint(ifConstraint, (PropertyConstraint)new CompoundPropertyConstraint(new And(thenConstraints)), type);
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint[] thenConstraints, PropertyConstraint[] elseConstraints) {
        return new ConditionalPropertyConstraint(ifConstraint, (PropertyConstraint)new CompoundPropertyConstraint(new And(thenConstraints)), new CompoundPropertyConstraint(new And(elseConstraints)));
    }

    public PropertyConstraint ifTrue(PropertyConstraint ifConstraint, PropertyConstraint[] thenConstraints, PropertyConstraint[] elseConstraints, String type) {
        return new ConditionalPropertyConstraint(ifConstraint, new CompoundPropertyConstraint(new And(thenConstraints)), new CompoundPropertyConstraint(new And(elseConstraints)), type);
    }

    public Constraint maxLength(int maxLength) {
        return new StringLengthConstraint(maxLength);
    }

    public Constraint minLength(int minLength) {
        return new StringLengthConstraint(RelationalOperator.GREATER_THAN_EQUAL_TO, minLength);
    }

    public Constraint like(String encodedLikeString) {
        return new Like(encodedLikeString);
    }

    public Constraint regexp(String regexp) {
        return new RegexpConstraint(regexp);
    }

    public Constraint regexp(String regexp, String type) {
        RegexpConstraint c = new RegexpConstraint(regexp);
        c.setType(type);
        return c;
    }

    public Constraint method(Object target, String methodName, String constraintType) {
        return new MethodInvokingConstraint(target, methodName, constraintType);
    }

    public Constraint inGroup(Set group) {
        return new InGroup(group);
    }

    public Constraint inGroup(Object[] group) {
        return new InGroup(group);
    }

    public Constraint inGroup(int[] group) {
        return this.inGroup(ObjectUtils.toObjectArray((Object)group));
    }

    public And and(Constraint constraint1, Constraint constraint2) {
        return new And(constraint1, constraint2);
    }

    public And all(Constraint[] constraints) {
        return new And(constraints);
    }

    public And conjunction() {
        return new And();
    }

    public Or or(Constraint constraint1, Constraint constraint2) {
        return new Or(constraint1, constraint2);
    }

    public Or any(Constraint[] constraints) {
        return new Or(constraints);
    }

    public Or disjunction() {
        return new Or();
    }

    public XOr exclusiveDisjunction() {
        return new XOr();
    }

    public Constraint not(Constraint constraint) {
        if (!(constraint instanceof Not)) {
            return new Not(constraint);
        }
        return ((Not)constraint).getConstraint();
    }

    public PropertyConstraint value(String propertyName, Constraint valueConstraint) {
        return new PropertyValueConstraint(propertyName, valueConstraint);
    }

    public PropertyConstraint present(String propertyName) {
        return this.value(propertyName, this.present());
    }

    public PropertyConstraint required(String property) {
        return this.value(property, this.required());
    }

    public PropertyConstraint like(String property, Like.LikeType likeType, String value) {
        return this.value(property, new Like(likeType, value));
    }

    public PropertyConstraint inGroup(String propertyName, Object[] group) {
        return this.value(propertyName, new InGroup(group));
    }

    public PropertyConstraint all(String propertyName, Constraint[] constraints) {
        return this.value(propertyName, this.all(constraints));
    }

    public PropertyConstraint any(String propertyName, Constraint[] constraints) {
        return this.value(propertyName, this.any(constraints));
    }

    public PropertyConstraint not(PropertyConstraint e) {
        return new NegatedPropertyConstraint(e);
    }

    public PropertyConstraint valueProperty(String propertyName, BinaryConstraint constraint, Object value) {
        return new ParameterizedPropertyConstraint(propertyName, constraint, value);
    }

    public PropertyConstraint eq(String propertyName, Object propertyValue) {
        return new ParameterizedPropertyConstraint(propertyName, this.eq(propertyValue));
    }

    public PropertyConstraint eq(String propertyName, Object propertyValue, Comparator comparator) {
        return new ParameterizedPropertyConstraint(propertyName, this.eq(propertyValue, comparator));
    }

    public PropertyConstraint gt(String propertyName, Comparable propertyValue) {
        return new ParameterizedPropertyConstraint(propertyName, this.gt(propertyValue));
    }

    public PropertyConstraint gte(String propertyName, Comparable propertyValue) {
        return new ParameterizedPropertyConstraint(propertyName, this.gte(propertyValue));
    }

    public PropertyConstraint lt(String propertyName, Comparable propertyValue) {
        return new ParameterizedPropertyConstraint(propertyName, this.lt(propertyValue));
    }

    public PropertyConstraint lte(String propertyName, Comparable propertyValue) {
        return new ParameterizedPropertyConstraint(propertyName, this.lte(propertyValue));
    }

    public PropertyConstraint valueProperties(String propertyName, BinaryConstraint constraint, String otherPropertyName) {
        return new PropertiesConstraint(propertyName, constraint, otherPropertyName);
    }

    public PropertyConstraint eqProperty(String propertyName, String otherPropertyName, Comparator comparator) {
        return this.valueProperties(propertyName, EqualTo.instance(comparator), otherPropertyName);
    }

    public PropertyConstraint gtProperty(String propertyName, String otherPropertyName, Comparator comparator) {
        return this.valueProperties(propertyName, GreaterThan.instance(comparator), otherPropertyName);
    }

    public PropertyConstraint gteProperty(String propertyName, String otherPropertyName, Comparator comparator) {
        return this.valueProperties(propertyName, GreaterThanEqualTo.instance(comparator), otherPropertyName);
    }

    public PropertyConstraint ltProperty(String propertyName, String otherPropertyName, Comparator comparator) {
        return this.valueProperties(propertyName, LessThan.instance(comparator), otherPropertyName);
    }

    public PropertyConstraint lteProperty(String propertyName, String otherPropertyName, Comparator comparator) {
        return this.valueProperties(propertyName, LessThanEqualTo.instance(comparator), otherPropertyName);
    }

    public PropertyConstraint inRange(String propertyName, Object min, Object max, Comparator comparator) {
        return this.value(propertyName, this.range(min, max, comparator));
    }

    public PropertyConstraint inRangeProperties(String propertyName, String minPropertyName, String maxPropertyName, Comparator comparator) {
        PropertyConstraint min = this.gteProperty(propertyName, minPropertyName, comparator);
        PropertyConstraint max = this.lteProperty(propertyName, maxPropertyName, comparator);
        return new CompoundPropertyConstraint(new And(min, max));
    }

    public PropertyConstraint eqProperty(String propertyName, String otherPropertyName) {
        return this.valueProperties(propertyName, EqualTo.instance(), otherPropertyName);
    }

    public PropertyConstraint gtProperty(String propertyName, String otherPropertyName) {
        return this.valueProperties(propertyName, GreaterThan.instance(), otherPropertyName);
    }

    public PropertyConstraint gteProperty(String propertyName, String otherPropertyName) {
        return this.valueProperties(propertyName, GreaterThanEqualTo.instance(), otherPropertyName);
    }

    public PropertyConstraint ltProperty(String propertyName, String otherPropertyName) {
        return this.valueProperties(propertyName, LessThan.instance(), otherPropertyName);
    }

    public PropertyConstraint lteProperty(String propertyName, String otherPropertyName) {
        return this.valueProperties(propertyName, LessThanEqualTo.instance(), otherPropertyName);
    }

    public PropertyConstraint inRange(String propertyName, Comparable min, Comparable max) {
        return this.value(propertyName, this.range(min, max));
    }

    public PropertyConstraint inRangeProperties(String propertyName, String minPropertyName, String maxPropertyName) {
        PropertyConstraint min = this.gteProperty(propertyName, minPropertyName);
        PropertyConstraint max = this.lteProperty(propertyName, maxPropertyName);
        return new CompoundPropertyConstraint(new And(min, max));
    }

    public PropertyConstraint unique(String propertyName) {
        return new UniquePropertyValueConstraint(propertyName);
    }
}

