/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.binding.support.BeanPropertyAccessStrategy;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.reporting.BeanValidationResults;
import org.springframework.rules.reporting.PropertyResults;
import org.springframework.rules.reporting.ValidationResultsBuilder;

public class BeanValidationResultsBuilder
extends ValidationResultsBuilder
implements BeanValidationResults {
    private String currentProperty;
    private Object currentPropertyValue;
    private Map beanResults = new HashMap();
    private PropertyAccessStrategy beanPropertyAccessStrategy;

    public BeanValidationResultsBuilder(Object bean) {
        this.beanPropertyAccessStrategy = bean instanceof PropertyAccessStrategy ? (PropertyAccessStrategy)bean : new BeanPropertyAccessStrategy(bean);
    }

    public Map getResults() {
        return Collections.unmodifiableMap(this.beanResults);
    }

    public PropertyResults getResults(String propertyName) {
        return (PropertyResults)this.beanResults.get(propertyName);
    }

    public int getViolatedCount() {
        int count = 0;
        Iterator it = this.beanResults.values().iterator();
        while (it.hasNext()) {
            count += ((PropertyResults)it.next()).getViolatedCount();
        }
        return count;
    }

    protected void constraintViolated(Constraint constraint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Done] collecting results for property '" + this.getCurrentPropertyName() + "'.  Constraints violated: [" + constraint + "]"));
        }
        PropertyResults results = new PropertyResults(this.getCurrentPropertyName(), this.getCurrentPropertyValue(), constraint);
        this.beanResults.put(this.getCurrentPropertyName(), results);
    }

    protected void constraintSatisfied() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Done] collecting results for property '" + this.getCurrentPropertyName() + "'.  All constraints met."));
        }
    }

    public String getCurrentPropertyName() {
        return this.currentProperty;
    }

    public Object getCurrentPropertyValue() {
        return this.currentPropertyValue;
    }

    public void setCurrentBeanPropertyExpression(PropertyConstraint expression) {
        this.currentProperty = expression.getPropertyName();
        this.currentPropertyValue = this.getPropertyValue(this.currentProperty);
        super.clear();
    }

    private Object getPropertyValue(String propertyName) {
        return this.beanPropertyAccessStrategy.getPropertyValue(propertyName);
    }
}

