/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import org.springframework.rules.Rules;
import org.springframework.rules.closure.support.Block;
import org.springframework.rules.constraint.Constraint;
import org.springframework.rules.constraint.property.CompoundPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.constraint.property.PropertyValueConstraint;
import org.springframework.rules.reporting.BeanValidationResults;
import org.springframework.rules.reporting.BeanValidationResultsBuilder;
import org.springframework.rules.reporting.PropertyResults;
import org.springframework.rules.reporting.ValidationResultsBuilder;
import org.springframework.rules.reporting.ValidationResultsCollector;
import org.springframework.util.Assert;

public class BeanValidationResultsCollector
extends ValidationResultsCollector {
    private Object bean;

    public BeanValidationResultsCollector(Object bean) {
        this.setBean(bean);
    }

    public void setBean(Object bean) {
        Assert.notNull((Object)bean, (String)"bean is required");
        this.bean = bean;
    }

    protected BeanValidationResultsBuilder getBeanResultsBuilder() {
        return (BeanValidationResultsBuilder)this.getResultsBuilder();
    }

    public void setResultsBuilder(ValidationResultsBuilder builder) {
        Assert.isTrue((boolean)(builder instanceof BeanValidationResultsBuilder), (String)"Builder must be a bean validation results builder");
        super.setResultsBuilder(builder);
    }

    public BeanValidationResults collectResults(Rules rules) {
        Assert.notNull((Object)rules, (String)"rules is required");
        this.setResultsBuilder(new BeanValidationResultsBuilder(this.bean));
        new Block(){

            protected void handle(Object beanPropertyConstraint) {
                BeanValidationResultsCollector.this.collectPropertyResultsInternal((PropertyConstraint)beanPropertyConstraint);
            }
        }.forEach(rules.iterator());
        return this.getBeanResultsBuilder();
    }

    public PropertyResults collectPropertyResults(PropertyConstraint propertyRootExpression) {
        Assert.notNull((Object)propertyRootExpression, (String)"propertyRootExpression is required");
        this.setResultsBuilder(new BeanValidationResultsBuilder(this.bean));
        return this.collectPropertyResultsInternal(propertyRootExpression);
    }

    private PropertyResults collectPropertyResultsInternal(PropertyConstraint rootExpression) {
        this.getBeanResultsBuilder().setCurrentBeanPropertyExpression(rootExpression);
        this.setArgument(this.getBeanResultsBuilder().getCurrentPropertyValue());
        boolean result = (Boolean)this.visitorSupport.invokeVisit((Object)this, (Object)rootExpression);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Final validation result: " + result));
        }
        if (!result) {
            return this.getBeanResultsBuilder().getResults(rootExpression.getPropertyName());
        }
        return null;
    }

    Boolean visit(CompoundPropertyConstraint rule) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating compound bean property expression [" + rule + "]..."));
        }
        return (Boolean)this.visitorSupport.invokeVisit((Object)this, (Object)rule.getPredicate());
    }

    boolean visit(PropertyConstraint constraint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating bean properties expression [" + constraint + "]..."));
        }
        return this.testBeanPropertyExpression(constraint);
    }

    private boolean testBeanPropertyExpression(PropertyConstraint constraint) {
        boolean result = constraint.test(this.bean);
        if (!(result = this.applyAnyNegation(result))) {
            this.getBeanResultsBuilder().push(constraint);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constraint [" + constraint + "] " + (result ? "passed" : "failed")));
        }
        return result;
    }

    Boolean visit(PropertyValueConstraint valueConstraint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Validating property value constraint [" + valueConstraint + "]..."));
        }
        return (Boolean)this.visitorSupport.invokeVisit((Object)this, (Object)valueConstraint.getConstraint());
    }

    boolean visit(Constraint constraint) {
        return super.visit(constraint);
    }
}

