/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.driver;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.EnumeratedStringParser;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.driver.ConsoleAuthenticator;
import gov.loc.repository.bagit.driver.ConstantCredentialsAuthenticator;
import gov.loc.repository.bagit.driver.NoCredentialsAuthenticator;
import gov.loc.repository.bagit.filesystem.filter.NotHiddenFileSystemNodeFilter;
import gov.loc.repository.bagit.progresslistener.CompositeProgressListener;
import gov.loc.repository.bagit.progresslistener.ConsoleProgressListener;
import gov.loc.repository.bagit.progresslistener.LoggingProgressListener;
import gov.loc.repository.bagit.transfer.BagFetcher;
import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.StandardFailStrategies;
import gov.loc.repository.bagit.transfer.ThresholdFailStrategy;
import gov.loc.repository.bagit.transfer.dest.FileSystemFileDestination;
import gov.loc.repository.bagit.transfer.fetch.ExternalRsyncFetchProtocol;
import gov.loc.repository.bagit.transfer.fetch.FtpFetchProtocol;
import gov.loc.repository.bagit.transfer.fetch.HttpFetchProtocol;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.impl.DefaultCompleter;
import gov.loc.repository.bagit.transformer.impl.HolePuncherImpl;
import gov.loc.repository.bagit.transformer.impl.SplitByFileType;
import gov.loc.repository.bagit.transformer.impl.SplitBySize;
import gov.loc.repository.bagit.transformer.impl.TagManifestCompleter;
import gov.loc.repository.bagit.transformer.impl.UpdateCompleter;
import gov.loc.repository.bagit.transformer.impl.UpdatePayloadOxumCompleter;
import gov.loc.repository.bagit.utilities.OperatingSystemHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SizeHelper;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import gov.loc.repository.bagit.verify.impl.ParallelManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.impl.ValidVerifierImpl;
import gov.loc.repository.bagit.writer.Writer;
import gov.loc.repository.bagit.writer.impl.FileSystemHelper;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import gov.loc.repository.bagit.writer.impl.ZipWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandLineBagDriver {
    public static final int RETURN_SUCCESS = 0;
    public static final int RETURN_FAILURE = 1;
    public static final int RETURN_ERROR = 2;
    public static final String OPERATION_VERIFYVALID = "verifyvalid";
    public static final String OPERATION_VERIFYCOMPLETE = "verifycomplete";
    public static final String OPERATION_MAKE_COMPLETE = "makecomplete";
    public static final String OPERATION_UPDATE = "update";
    public static final String OPERATION_UPDATE_TAGMANIFESTS = "updatetagmanifests";
    public static final String OPERATION_CREATE = "create";
    public static final String OPERATION_MAKE_HOLEY = "makeholey";
    public static final String OPERATION_GENERATE_PAYLOAD_OXUM = "generatepayloadoxum";
    public static final String OPERATION_UPDATE_PAYLOAD_OXUM = "updatepayloadoxum";
    public static final String OPERATION_CHECK_PAYLOAD_OXUM = "checkpayloadoxum";
    public static final String OPERATION_VERIFY_PAYLOADMANIFESTS = "verifypayloadmanifests";
    public static final String OPERATION_VERIFY_TAGMANIFESTS = "verifytagmanifests";
    public static final String OPERATION_RETRIEVE = "retrieve";
    public static final String OPERATION_FILL_HOLEY = "fillholey";
    public static final String OPERATION_BAG_IN_PLACE = "baginplace";
    public static final String OPERATION_SPLIT_BAG_BY_SIZE = "splitbagbysize";
    public static final String OPERATION_SPLIT_BAG_BY_FILE_TYPE = "splitbagbyfiletype";
    public static final String OPERATION_SPLIT_BAG_BY_SIZE_AND_FILE_TYPE = "splitbagbysizeandfiletype";
    public static final String PARAM_SOURCE = "source";
    public static final String PARAM_DESTINATION = "dest";
    public static final String PARAM_MISSING_BAGIT_TOLERANT = "missingbagittolerant";
    public static final String PARAM_ADDITIONAL_DIRECTORY_TOLERANT = "additionaldirectorytolerant";
    public static final String PARAM_MANIFEST_SEPARATOR = "manifestseparator";
    public static final String PARAM_WRITER = "writer";
    public static final String PARAM_PAYLOAD = "payload";
    public static final String PARAM_EXCLUDE_PAYLOAD_DIR = "excludepayloaddir";
    public static final String PARAM_BASE_URL = "baseurl";
    public static final String PARAM_URL = "url";
    public static final String PARAM_EXCLUDE_BAG_INFO = "excludebaginfo";
    public static final String PARAM_NO_UPDATE_PAYLOAD_OXUM = "noupdatepayloadoxum";
    public static final String PARAM_NO_UPDATE_BAGGING_DATE = "noupdatebaggingdate";
    public static final String PARAM_NO_UPDATE_BAG_SIZE = "noupdatebagsize";
    public static final String PARAM_EXCLUDE_TAG_MANIFEST = "excludetagmanifest";
    public static final String PARAM_TAG_MANIFEST_ALGORITHM = "tagmanifestalgorithm";
    public static final String PARAM_PAYLOAD_MANIFEST_ALGORITHM = "payloadmanifestalgorithm";
    public static final String PARAM_VERSION = "version";
    public static final String PARAM_THREADS = "threads";
    public static final String PARAM_FETCH_RETRY = "on-failure";
    public static final String PARAM_FETCH_FAILURE_THRESHOLD = "max-failures";
    public static final String PARAM_FETCH_FILE_FAILURE_THRESHOLD = "max-file-failures";
    public static final String PARAM_RELAX_SSL = "relaxssl";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_THROTTLE = "throttle";
    public static final String PARAM_HELP = "help";
    public static final String PARAM_RETAIN_BASE_DIR = "retainbasedir";
    public static final String PARAM_BAGINFOTXT = "baginfotxt";
    public static final String PARAM_NO_RESULTFILE = "noresultfile";
    public static final String PARAM_RESUME = "resume";
    public static final String PARAM_VERIFY = "verify";
    public static final String PARAM_MAX_BAG_SIZE = "maxbagsize";
    public static final String PARAM_KEEP_LOWEST_LEVEL_DIR = "keeplowestleveldir";
    public static final String PARAM_FILE_EXTENSIONS = "fileextensions";
    public static final String PARAM_EXCLUDE_DIRS = "excludedirs";
    public static final String PARAM_KEEP_SOURCE_BAG = "keepsourcebag";
    public static final String PARAM_KEEP_EMPTY_DIRS = "keepemptydirs";
    public static final String PARAM_VERBOSE = "verbose";
    public static final String PARAM_LOG_VERBOSE = "log-verbose";
    public static final String PARAM_EXCLUDE_SYMLINKS = "excludesymlinks";
    public static final String PARAM_FAIL_MODE = "failmode";
    public static final String PARAM_COMPRESSION_LEVEL = "compressionlevel";
    public static final String PARAM_MOVE = "move";
    public static final String PARAM_EXCLUDE_HIDDEN = "excludehiddenfiles";
    public static final String VALUE_WRITER_FILESYSTEM = Bag.Format.FILESYSTEM.name().toLowerCase();
    public static final String VALUE_WRITER_ZIP = Bag.Format.ZIP.name().toLowerCase();
    private static final Log log = LogFactory.getLog(CommandLineBagDriver.class);
    private Map<String, Operation> operationMap = new HashMap<String, Operation>();

    public static void main(String[] args) throws Exception {
        CommandLineBagDriver driver = new CommandLineBagDriver();
        int ret = driver.execute(args);
        if (ret == 2) {
            System.err.println(MessageFormat.format("An error occurred. Check the {0}/logs/bag-{1}.log for more details.", System.getProperty("app.home"), System.getProperty("log.timestamp")));
        }
        System.exit(ret);
    }

    public CommandLineBagDriver() throws Exception {
        UnflaggedOption sourceParam = new UnflaggedOption(PARAM_SOURCE, (StringParser)FileStringParser.getParser().setMustExist(true), null, true, false, "The location of the source bag.");
        UnflaggedOption destParam = new UnflaggedOption(PARAM_DESTINATION, (StringParser)JSAP.STRING_PARSER, null, true, false, "The location of the destination bag.");
        FlaggedOption optionalDestParam = new FlaggedOption(PARAM_DESTINATION, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PARAM_DESTINATION, "The location of the destination bag (if different than the source bag).");
        FlaggedOption optionalSplitDestParam = new FlaggedOption(PARAM_DESTINATION, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PARAM_DESTINATION, "The location of the split bags. The default <parent dir of source bag>/<source bag name>_split.");
        Switch missingBagItTolerantParam = new Switch(PARAM_MISSING_BAGIT_TOLERANT, '\u0000', PARAM_MISSING_BAGIT_TOLERANT, "Tolerant of a missing bagit.txt.");
        Switch additionalDirectoryTolerantParam = new Switch(PARAM_ADDITIONAL_DIRECTORY_TOLERANT, '\u0000', PARAM_ADDITIONAL_DIRECTORY_TOLERANT, "Tolerant of additional directories in the bag_dir.");
        FlaggedOption manifestSeparatorParam = new FlaggedOption(PARAM_MANIFEST_SEPARATOR, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PARAM_MANIFEST_SEPARATOR, "Delimiter used in Payload and Tag Manifest files.  Place within quotes for whitespace.");
        FlaggedOption writerParam = new FlaggedOption(PARAM_WRITER, (StringParser)EnumeratedStringParser.getParser((String)(VALUE_WRITER_FILESYSTEM + ";" + VALUE_WRITER_ZIP)), VALUE_WRITER_FILESYSTEM, false, '\u0000', PARAM_WRITER, MessageFormat.format("The writer to use to write the bag. Valid values are {0} and {1}.", VALUE_WRITER_FILESYSTEM, VALUE_WRITER_ZIP));
        UnflaggedOption payloadParam = new UnflaggedOption(PARAM_PAYLOAD, (StringParser)JSAP.STRING_PARSER, null, true, true, "List of files/directories to include in payload. To add the children of a directory, but not the directory itself append with " + File.separator + "*.");
        Switch excludePayloadDirParam = new Switch(PARAM_EXCLUDE_PAYLOAD_DIR, '\u0000', PARAM_EXCLUDE_PAYLOAD_DIR, "Exclude the payload directory when constructing the url.");
        UnflaggedOption baseUrlParam = new UnflaggedOption(PARAM_BASE_URL, (StringParser)JSAP.STRING_PARSER, null, true, false, "The base url to be prepended in creating the fetch.txt.");
        UnflaggedOption retrieveUrlParam = new UnflaggedOption(PARAM_URL, (StringParser)JSAP.STRING_PARSER, null, true, false, "The url to retrieve the bag from.");
        FlaggedOption threadsParam = new FlaggedOption(PARAM_THREADS, (StringParser)JSAP.INTEGER_PARSER, null, false, '\u0000', PARAM_THREADS, "The number of threads to use.  Default is equal to the number of processors.");
        FlaggedOption fetchRetryParam = new FlaggedOption(PARAM_FETCH_RETRY, (StringParser)EnumeratedStringParser.getParser((String)"none;next;retry;threshold"), "threshold", false, '\u0000', PARAM_FETCH_RETRY, "How to handle fetch failures.  Must be one of none, next, retry, or threshold.");
        FlaggedOption fetchFailThreshold = new FlaggedOption(PARAM_FETCH_FAILURE_THRESHOLD, (StringParser)JSAP.INTEGER_PARSER, "200", false, '\u0000', PARAM_FETCH_FAILURE_THRESHOLD, "The number of total fetch failures to tolerate before giving up.");
        FlaggedOption fetchFileFailThreshold = new FlaggedOption(PARAM_FETCH_FILE_FAILURE_THRESHOLD, (StringParser)JSAP.INTEGER_PARSER, "3", false, '\u0000', PARAM_FETCH_FILE_FAILURE_THRESHOLD, "The number times to retry a file before giving up on that file.");
        Switch excludeBagInfoParam = new Switch(PARAM_EXCLUDE_BAG_INFO, '\u0000', PARAM_EXCLUDE_BAG_INFO, "Excludes creating bag-info.txt, if necessary, when completing a bag.");
        Switch noUpdatePayloadOxumParam = new Switch(PARAM_NO_UPDATE_PAYLOAD_OXUM, '\u0000', PARAM_NO_UPDATE_PAYLOAD_OXUM, "Does not update Payload-Oxum in bag-info.txt when completing a bag.");
        Switch noUpdateBaggingDateParam = new Switch(PARAM_NO_UPDATE_BAGGING_DATE, '\u0000', PARAM_NO_UPDATE_BAGGING_DATE, "Does not update Bagging-Date in bag-info.txt when completing a bag.");
        Switch noUpdateBagSizeParam = new Switch(PARAM_NO_UPDATE_BAG_SIZE, '\u0000', PARAM_NO_UPDATE_BAG_SIZE, "Does not update Bag-Size in bag-info.txt when completing a bag.");
        Switch excludeTagManifestParam = new Switch(PARAM_EXCLUDE_TAG_MANIFEST, '\u0000', PARAM_EXCLUDE_TAG_MANIFEST, "Excludes creating a tag manifest when completing a bag.");
        FlaggedOption tagManifestAlgorithmParam = new FlaggedOption(PARAM_TAG_MANIFEST_ALGORITHM, (StringParser)EnumeratedStringParser.getParser((String)CommandLineBagDriver.getAlgorithmList()), Manifest.Algorithm.MD5.bagItAlgorithm, false, '\u0000', PARAM_TAG_MANIFEST_ALGORITHM, MessageFormat.format("The algorithm used to generate the tag manifest. Valid values are {0}. Default is {1}.", CommandLineBagDriver.getAlgorithmListString(), Manifest.Algorithm.MD5.bagItAlgorithm));
        FlaggedOption payloadManifestAlgorithmParam = new FlaggedOption(PARAM_PAYLOAD_MANIFEST_ALGORITHM, (StringParser)EnumeratedStringParser.getParser((String)CommandLineBagDriver.getAlgorithmList()), Manifest.Algorithm.MD5.bagItAlgorithm, false, '\u0000', PARAM_PAYLOAD_MANIFEST_ALGORITHM, MessageFormat.format("The algorithm used to generate the payload manifest. Valid values are {0}. Default is {1}.", CommandLineBagDriver.getAlgorithmListString(), Manifest.Algorithm.MD5.bagItAlgorithm));
        FlaggedOption versionParam = new FlaggedOption(PARAM_VERSION, (StringParser)EnumeratedStringParser.getParser((String)CommandLineBagDriver.getVersionList(), (boolean)false, (boolean)false), null, false, '\u0000', PARAM_VERSION, MessageFormat.format("The version used to check the bag. Valid values are {0}. Default is to discover from the bagit.txt or latest version.", CommandLineBagDriver.getVersionListString()));
        Switch relaxSSLParam = new Switch(PARAM_RELAX_SSL, '\u0000', PARAM_RELAX_SSL, "Tolerant of self-signed SSL certificates.");
        FlaggedOption usernameParam = new FlaggedOption(PARAM_USERNAME, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PARAM_USERNAME, "The username for basic authentication.");
        FlaggedOption passwordParam = new FlaggedOption(PARAM_PASSWORD, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PARAM_PASSWORD, "The password for basic authentication.");
        Switch retainBaseDirParam = new Switch(PARAM_RETAIN_BASE_DIR, '\u0000', PARAM_RETAIN_BASE_DIR, "Indicates that the base directory (not just the contents of the base directory) should be placed in the data directory of the bag.");
        FlaggedOption bagInfoTxtParam = new FlaggedOption(PARAM_BAGINFOTXT, (StringParser)FileStringParser.getParser().setMustExist(true), null, false, '\u0000', PARAM_BAGINFOTXT, "An external bag-info.txt file to include in the bag.");
        Switch noResultFileParam = new Switch(PARAM_NO_RESULTFILE, '\u0000', PARAM_NO_RESULTFILE, "Suppress creating a result file.");
        Switch resumeParam = new Switch(PARAM_RESUME, '\u0000', PARAM_RESUME, "Resume from where the fetch left off.");
        Switch verifyParam = new Switch(PARAM_VERIFY, '\u0000', PARAM_VERIFY, "Verify the bag before fetch is resumed.");
        FlaggedOption maxBagSizeParam = new FlaggedOption(PARAM_MAX_BAG_SIZE, (StringParser)JSAP.DOUBLE_PARSER, null, false, '\u0000', PARAM_MAX_BAG_SIZE, "The max size of a split bag in GB. Default is 300GB.");
        Switch keepLowestLevelDirParam = new Switch(PARAM_KEEP_LOWEST_LEVEL_DIR, '\u0000', PARAM_KEEP_LOWEST_LEVEL_DIR, "Does not split the lowest level directory.");
        UnflaggedOption fileExtensionsParam = new UnflaggedOption(PARAM_FILE_EXTENSIONS, (StringParser)JSAP.STRING_PARSER, null, true, false, "File types delimited by a comma will be grouped into different bags; file types delimited by a colon will be grouped into one single bag.");
        FlaggedOption excludeDirsParam = new FlaggedOption(PARAM_EXCLUDE_DIRS, (StringParser)JSAP.STRING_PARSER, null, false, '\u0000', PARAM_EXCLUDE_DIRS, "Directories in the bag to be ignored in the split operation; they will be kept in the source bag; they should be relative to the base path of the bag. ");
        Switch keepEmptyDirsParam = new Switch(PARAM_KEEP_EMPTY_DIRS, '\u0000', PARAM_KEEP_EMPTY_DIRS, "Retains empty directories by placing .keep files in them.");
        Switch excludeSymlinksParam = new Switch(PARAM_EXCLUDE_SYMLINKS, '\u0000', PARAM_EXCLUDE_SYMLINKS, "Ignore symbolic links (for bags on file systems only).");
        FlaggedOption failModeParam = new FlaggedOption(PARAM_FAIL_MODE, (StringParser)EnumeratedStringParser.getParser((String)CommandLineBagDriver.getFailModeList()), FailModeSupporting.FailMode.FAIL_FAST.name(), false, '\u0000', PARAM_FAIL_MODE, MessageFormat.format("The fail mode for the verification.  Valid values are {0} (fail on first error), {1} (fail over step of verification. A step is a set of like verification operations. For example, check that all payload files are in at least one manifest.), {2} (fail after stage of verification. A stage is a set of logically grouped verification operations. For example, when validating a bag, all of the operations to verify that a bag is complete is a stage. This mode is how previous versions of BIL operated.), {3} (complete verification then fail).", FailModeSupporting.FailMode.FAIL_FAST.name(), FailModeSupporting.FailMode.FAIL_STEP.name(), FailModeSupporting.FailMode.FAIL_STAGE.name(), FailModeSupporting.FailMode.FAIL_SLOW.name()));
        FlaggedOption compressionParam = new FlaggedOption(PARAM_COMPRESSION_LEVEL, (StringParser)JSAP.INTEGER_PARSER, "0", false, '\u0000', PARAM_COMPRESSION_LEVEL, "The compression level to apply to zip files. Valid values are 1 (least compression, fastest) to 9 (most compression, slowest).");
        Switch moveParam = new Switch(PARAM_MOVE, '\u0000', PARAM_MOVE, "When using file system writer, moves files instead of copying them.");
        this.addOperation(OPERATION_VERIFY_TAGMANIFESTS, "Verifies the checksums in all tag manifests.", new Parameter[]{sourceParam, versionParam, noResultFileParam, failModeParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_VERIFY_TAGMANIFESTS, this.getBag("mybag"))});
        this.addOperation(OPERATION_VERIFY_PAYLOADMANIFESTS, "Verifies the checksums in all payload manifests.", new Parameter[]{sourceParam, versionParam, noResultFileParam, failModeParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_VERIFY_PAYLOADMANIFESTS, this.getBag("mybag"))});
        this.addOperation(OPERATION_VERIFYVALID, "Verifies the validity of a bag.", new Parameter[]{sourceParam, versionParam, missingBagItTolerantParam, additionalDirectoryTolerantParam, noResultFileParam, excludeSymlinksParam, failModeParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_VERIFYVALID, this.getBag("mybag"))});
        this.addOperation(OPERATION_VERIFYCOMPLETE, "Verifies the completeness of a bag.", new Parameter[]{sourceParam, versionParam, missingBagItTolerantParam, additionalDirectoryTolerantParam, noResultFileParam, excludeSymlinksParam, failModeParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_VERIFYCOMPLETE, this.getBag("mybag"))});
        this.addOperation(OPERATION_SPLIT_BAG_BY_SIZE, "Splits a bag by size.", new Parameter[]{sourceParam, optionalSplitDestParam, maxBagSizeParam, keepLowestLevelDirParam, writerParam, moveParam, compressionParam, excludeDirsParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_SPLIT_BAG_BY_SIZE, this.getBag("mybag"))});
        this.addOperation(OPERATION_SPLIT_BAG_BY_FILE_TYPE, "Splits a bag by file types.", new Parameter[]{sourceParam, fileExtensionsParam, optionalSplitDestParam, writerParam, moveParam, compressionParam, excludeDirsParam}, new String[]{MessageFormat.format("bag {0} {1} {2}", OPERATION_SPLIT_BAG_BY_FILE_TYPE, this.getBag("mybag"), "pdf,gif")});
        this.addOperation(OPERATION_SPLIT_BAG_BY_SIZE_AND_FILE_TYPE, "Splits a bag by size and file types.", new Parameter[]{sourceParam, fileExtensionsParam, optionalSplitDestParam, maxBagSizeParam, keepLowestLevelDirParam, writerParam, moveParam, compressionParam, excludeDirsParam}, new String[]{MessageFormat.format("bag {0} {1} {2}", OPERATION_SPLIT_BAG_BY_SIZE_AND_FILE_TYPE, this.getBag("mybag"), "pdf,gif:xml,gif")});
        ArrayList<Object> completeParams = new ArrayList<Object>();
        completeParams.add(excludeBagInfoParam);
        completeParams.add(noUpdateBaggingDateParam);
        completeParams.add(noUpdateBagSizeParam);
        completeParams.add(noUpdatePayloadOxumParam);
        completeParams.add(excludeTagManifestParam);
        completeParams.add(tagManifestAlgorithmParam);
        completeParams.add(payloadManifestAlgorithmParam);
        completeParams.add(versionParam);
        completeParams.add(manifestSeparatorParam);
        ArrayList<Parameter> makeCompleteParams = new ArrayList<Parameter>();
        makeCompleteParams.add((Parameter)sourceParam);
        makeCompleteParams.add((Parameter)destParam);
        makeCompleteParams.add((Parameter)writerParam);
        makeCompleteParams.add((Parameter)moveParam);
        makeCompleteParams.add((Parameter)compressionParam);
        makeCompleteParams.addAll(completeParams);
        this.addOperation(OPERATION_MAKE_COMPLETE, "Completes a bag and then writes in a specified format.  Completing a bag fills in any missing parts.", makeCompleteParams, new String[]{MessageFormat.format("bag {0} {1} {2}", OPERATION_MAKE_COMPLETE, this.getBag("mybag"), this.getBag("myDestBag"))});
        this.addOperation(OPERATION_UPDATE, "Updates the manifests and (if it exists) the bag-info.txt for a bag.", new Parameter[]{sourceParam, optionalDestParam, writerParam, moveParam, compressionParam, manifestSeparatorParam, tagManifestAlgorithmParam, payloadManifestAlgorithmParam}, new String[]{MessageFormat.format("bag {0} {1} ", OPERATION_UPDATE, this.getBag("mybag"))});
        this.addOperation(OPERATION_UPDATE_TAGMANIFESTS, "Updates the tag manifests for a bag.  The bag must be unserialized.", new Parameter[]{sourceParam, tagManifestAlgorithmParam, manifestSeparatorParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_UPDATE_TAGMANIFESTS, this.getBag("mybag"))});
        this.addOperation(OPERATION_UPDATE_PAYLOAD_OXUM, "Generates and updates the Payload-Oxum in the bag-info.txt.  The bag must be unserialized.", new Parameter[]{sourceParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_UPDATE_PAYLOAD_OXUM, this.getBag("mybag"))});
        ArrayList<Parameter> bagInPlaceParams = new ArrayList<Parameter>();
        bagInPlaceParams.add((Parameter)sourceParam);
        bagInPlaceParams.add((Parameter)retainBaseDirParam);
        bagInPlaceParams.addAll(completeParams);
        bagInPlaceParams.add((Parameter)bagInfoTxtParam);
        bagInPlaceParams.add((Parameter)keepEmptyDirsParam);
        this.addOperation(OPERATION_BAG_IN_PLACE, "Creates a bag-in-place.  The source must be a directory on a filesystem and may already have a data directory.", bagInPlaceParams, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_BAG_IN_PLACE, this.getBag("mybag"))});
        ArrayList<Parameter> createParams = new ArrayList<Parameter>();
        createParams.add((Parameter)destParam);
        createParams.add((Parameter)payloadParam);
        createParams.add((Parameter)writerParam);
        createParams.add((Parameter)moveParam);
        createParams.add((Parameter)compressionParam);
        createParams.addAll(completeParams);
        createParams.add((Parameter)bagInfoTxtParam);
        this.addOperation(OPERATION_CREATE, "Creates a bag from supplied files/directories, completes the bag, and then writes in a specified format.", createParams, new String[]{MessageFormat.format("bag {0} {1} {2} {3}", OPERATION_CREATE, this.getBag("mybag"), this.getData("somedata"), this.getData("otherdata/afile.txt"))});
        ArrayList<Parameter> makeHoleyParam = new ArrayList<Parameter>();
        makeHoleyParam.add((Parameter)sourceParam);
        makeHoleyParam.add((Parameter)destParam);
        makeHoleyParam.add((Parameter)baseUrlParam);
        makeHoleyParam.add((Parameter)writerParam);
        makeHoleyParam.add((Parameter)moveParam);
        makeHoleyParam.add((Parameter)compressionParam);
        makeHoleyParam.add((Parameter)excludePayloadDirParam);
        makeHoleyParam.add((Parameter)resumeParam);
        this.addOperation(OPERATION_MAKE_HOLEY, "Generates a fetch.txt and then writes bag in a specified format.", makeHoleyParam, new String[]{MessageFormat.format("bag {0} {1} {2} http://www.loc.gov/bags", OPERATION_MAKE_HOLEY, this.getBag("mybag"), this.getBag("myDestBag"))});
        this.addOperation(OPERATION_GENERATE_PAYLOAD_OXUM, "Generates and returns the Payload-Oxum for the bag.", new Parameter[]{sourceParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_GENERATE_PAYLOAD_OXUM, this.getBag("mybag"))});
        this.addOperation(OPERATION_CHECK_PAYLOAD_OXUM, "Generates Payload-Oxum and checks against Payload-Oxum in bag-info.txt.", new Parameter[]{sourceParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_CHECK_PAYLOAD_OXUM, this.getBag("mybag"))});
        this.addOperation(OPERATION_RETRIEVE, "Retrieves a bag exposed by a web server. A local holey bag is not required.", new Parameter[]{destParam, retrieveUrlParam, relaxSSLParam, threadsParam, fetchRetryParam, fetchFileFailThreshold, fetchFailThreshold, usernameParam, passwordParam, resumeParam, verifyParam}, new String[]{MessageFormat.format("bag {0} {1} http://www.loc.gov/bags/mybag", OPERATION_RETRIEVE, this.getBag("myDestBag"))});
        this.addOperation(OPERATION_FILL_HOLEY, "Retrieves any missing pieces of a local bag.", new Parameter[]{sourceParam, relaxSSLParam, threadsParam, fetchRetryParam, fetchFileFailThreshold, fetchFailThreshold, usernameParam, passwordParam, resumeParam, verifyParam}, new String[]{MessageFormat.format("bag {0} {1}", OPERATION_FILL_HOLEY, this.getBag("mybag"))});
    }

    private String getBag(String bagName) {
        if (OperatingSystemHelper.isWindows()) {
            return "c:\\bags\\" + bagName;
        }
        return "/bags/" + bagName;
    }

    private String getData(String filepath) {
        if (OperatingSystemHelper.isWindows()) {
            return "c:\\data\\" + filepath;
        }
        return "/data/" + filepath;
    }

    private void addOperation(String name, String help, Parameter[] params, String[] examples) throws Exception {
        JSAP jsap = new JSAP();
        for (Parameter param : params) {
            jsap.registerParameter(param);
        }
        jsap.registerParameter((Parameter)new Switch(PARAM_HELP, '\u0000', PARAM_HELP, "Prints help."));
        jsap.registerParameter((Parameter)new Switch(PARAM_VERBOSE, '\u0000', PARAM_VERBOSE, "Reports progress of the operation to the console."));
        jsap.registerParameter((Parameter)new Switch(PARAM_LOG_VERBOSE, '\u0000', PARAM_LOG_VERBOSE, "Reports progress of the operation to the log."));
        jsap.registerParameter((Parameter)new Switch(PARAM_EXCLUDE_HIDDEN, '\u0000', PARAM_EXCLUDE_HIDDEN, "Exclude hidden files."));
        this.operationMap.put(name, new Operation(name, jsap, help, examples));
    }

    private void addOperation(String name, String help, List<Parameter> params, String[] examples) throws Exception {
        this.addOperation(name, help, params.toArray(new Parameter[0]), examples);
    }

    public int execute(String[] args) throws Exception {
        log.debug((Object)("Executing with arguments: " + CommandLineBagDriver.argsToString(args)));
        int ret = 0;
        if (args.length == 0 || args.length == 1 && args[0].equals("--help")) {
            this.printUsage();
        } else if (args.length == 1 && args[0].equals("--version")) {
            this.printVersion();
        } else {
            String operationArg = args[0];
            if (!this.operationMap.containsKey(operationArg)) {
                System.err.println("Error: Unknown operation.");
                this.printUsage();
                ret = 2;
            } else {
                Operation operation = this.operationMap.get(operationArg);
                String[] newArgs = new String[args.length - 1];
                if (newArgs.length > 0) {
                    System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                } else {
                    newArgs = new String[]{"--help"};
                }
                JSAPResult config = operation.jsap.parse(newArgs);
                if (config.getBoolean(PARAM_HELP, false)) {
                    this.printOperationUsage(config, operation);
                } else if (!config.success()) {
                    this.printOperationUsage(config, operation);
                    System.err.println("Error parse arguments.");
                    ret = 2;
                } else {
                    ret = this.performOperation(operation, config);
                }
            }
        }
        log.info((Object)("Returning " + ret));
        return ret;
    }

    private static String getAlgorithmList() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Manifest.Algorithm.values().length; ++i) {
            sb.append(Manifest.Algorithm.values()[i].bagItAlgorithm);
            if (i == Manifest.Algorithm.values().length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    private static String getFailModeList() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < FailModeSupporting.FailMode.values().length; ++i) {
            sb.append((Object)FailModeSupporting.FailMode.values()[i]);
            if (i == FailModeSupporting.FailMode.values().length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    private static String getAlgorithmListString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < Manifest.Algorithm.values().length; ++i) {
            sb.append(Manifest.Algorithm.values()[i].bagItAlgorithm);
            if (i != Manifest.Algorithm.values().length - 1) {
                sb.append(" and ");
                continue;
            }
            if (i == Manifest.Algorithm.values().length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String getVersionList() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < BagFactory.Version.values().length; ++i) {
            sb.append(BagFactory.Version.values()[i].versionString);
            if (i == BagFactory.Version.values().length - 1) continue;
            sb.append(';');
        }
        return sb.toString();
    }

    private static String getVersionListString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < BagFactory.Version.values().length; ++i) {
            sb.append(BagFactory.Version.values()[i].versionString);
            if (i != BagFactory.Version.values().length - 1) {
                sb.append(" and ");
                continue;
            }
            if (i == BagFactory.Version.values().length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void printOperationUsage(JSAPResult config, Operation operation) {
        if (!config.getBoolean(PARAM_HELP, false)) {
            Iterator errIter = config.getErrorMessageIterator();
            while (errIter.hasNext()) {
                System.err.println("Error: " + (String)errIter.next());
            }
        }
        System.out.println(MessageFormat.format("Usage: bag {0} {1}", operation.name, operation.jsap.getUsage()));
        System.out.println("Operation explanation:");
        System.out.println("\t" + operation.help);
        System.out.println("Operation parameters:");
        System.out.println(operation.jsap.getHelp());
        if (operation.examples.length > 0) {
            System.out.println("Examples:");
            for (String example : operation.examples) {
                System.out.println("\t" + example);
            }
        }
    }

    private String getVersion() {
        return System.getProperty(PARAM_VERSION);
    }

    private void printVersion() {
        System.out.println("BagIt Library (BIL) Version " + this.getVersion());
    }

    private void printUsage() {
        this.printVersion();
        System.out.println("Usage: bag <operation> [operation arguments] [--help]");
        System.out.println("Parameters:");
        System.out.println("\t<operation>");
        System.out.print("\t\tValid operations are: ");
        ArrayList<String> names = new ArrayList<String>(this.operationMap.keySet());
        Collections.sort(names);
        for (int i = 0; i < names.size(); ++i) {
            System.out.print((String)names.get(i));
            if (i == names.size() - 2) {
                System.out.print(" and ");
                continue;
            }
            if (i == names.size() - 1) {
                System.out.println(".");
                continue;
            }
            System.out.print(", ");
        }
        System.out.println("\t\tOperation explanations: ");
        for (String name : names) {
            System.out.println(MessageFormat.format("\t\t\t{0}: {1}", name, this.operationMap.get((Object)name).help));
        }
        System.out.println("\t[--version]");
        System.out.println("\t\tPrints version of BIL and exits.");
        System.out.println("\t[--help]");
        System.out.println("\t\tPrints usage message for the operation.");
        System.out.println("Examples:");
        System.out.println("\tbag verifyvalid --help");
        System.out.println("\t\tPrints help for the verifyvalid operation.");
    }

    private static String argsToString(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    private Bag getBag(BagFactory bagFactory, File sourceFile, BagFactory.Version version, BagFactory.LoadOption loadOption) {
        if (version != null) {
            if (sourceFile != null) {
                return bagFactory.createBag(sourceFile, version, loadOption);
            }
            return bagFactory.createBag(version);
        }
        if (sourceFile != null) {
            return bagFactory.createBag(sourceFile, loadOption);
        }
        return bagFactory.createBag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int performOperation(Operation operation, JSAPResult config) {
        msg = "Performing operation: " + operation.name;
        CommandLineBagDriver.log.info((Object)msg);
        try {
            block169: {
                listener = new CompositeProgressListener();
                if (config.getBoolean("verbose")) {
                    listener.addProgressListener(new ConsoleProgressListener());
                }
                if (config.getBoolean("log-verbose")) {
                    listener.addProgressListener(new LoggingProgressListener());
                }
                sourceFile = null;
                if (config.contains("source")) {
                    sourceFile = config.getFile("source");
                }
                version = null;
                if (config.contains("version")) {
                    version = BagFactory.Version.valueOfString(config.getString("version"));
                }
                destFile = null;
                if (config.contains("dest")) {
                    destFile = new File(config.getString("dest"));
                }
                bagFactory = null;
                bagFactory = config.getBoolean("excludehiddenfiles") != false ? new BagFactory(new NotHiddenFileSystemNodeFilter()) : new BagFactory(null);
                writer = null;
                if (config.contains("writer")) {
                    format = Bag.Format.valueOf(config.getString("writer").toUpperCase());
                    if (Bag.Format.FILESYSTEM.equals((Object)format)) {
                        writer = new FileSystemWriter(bagFactory);
                        if (config.getBoolean("move")) {
                            ((FileSystemWriter)writer).setPayloadWriteMode(FileSystemWriter.WriteMode.MOVE);
                        }
                    } else if (Bag.Format.ZIP.equals((Object)format)) {
                        writer = new ZipWriter(bagFactory);
                        compressionLevel = config.getInt("compressionlevel");
                        if (compressionLevel >= 1 && compressionLevel <= 9) {
                            ((ZipWriter)writer).setCompressionLevel(compressionLevel);
                        }
                    }
                }
                if (writer != null) {
                    writer.addProgressListener(listener);
                }
                manifestSeparator = null;
                ret = 0;
                if (config.contains("manifestseparator")) {
                    manifestSeparator = config.getString("manifestseparator").replace("\\t", "\t");
                }
                completer = new DefaultCompleter(bagFactory);
                completer.setGenerateBagInfoTxt(config.getBoolean("excludebaginfo", false) == false);
                completer.setUpdateBaggingDate(config.getBoolean("noupdatebaggingdate", false) == false);
                completer.setUpdateBagSize(config.getBoolean("noupdatebagsize", false) == false);
                completer.setUpdatePayloadOxum(config.getBoolean("noupdatepayloadoxum", false) == false);
                completer.setGenerateTagManifest(config.getBoolean("excludetagmanifest", false) == false);
                completer.setTagManifestAlgorithm(Manifest.Algorithm.valueOfBagItAlgorithm(config.getString("tagmanifestalgorithm", Manifest.Algorithm.MD5.bagItAlgorithm)));
                completer.setPayloadManifestAlgorithm(Manifest.Algorithm.valueOfBagItAlgorithm(config.getString("payloadmanifestalgorithm", Manifest.Algorithm.MD5.bagItAlgorithm)));
                completer.setNonDefaultManifestSeparator(manifestSeparator);
                completer.addProgressListener(listener);
                fetcher = new BagFetcher(bagFactory);
                fetcher.addProgressListener(listener);
                v0 = writeResultFile = config.getBoolean("noresultfile", false) == false;
                if (operation.name.equals("fillholey") || operation.name.equals("retrieve")) {
                    username = config.getString("username");
                    password = config.getString("password");
                    if (username != null && password != null) {
                        Authenticator.setDefault(new ConstantCredentialsAuthenticator(username, password));
                    } else if (username != null && password == null) {
                        Authenticator.setDefault(new ConsoleAuthenticator(username));
                    } else {
                        Authenticator.setDefault(new NoCredentialsAuthenticator());
                    }
                    http = new HttpFetchProtocol();
                    http.setRelaxedSsl(config.getBoolean("relaxssl", false));
                    fetcher.registerProtocol("http", http);
                    fetcher.registerProtocol("https", http);
                    fetcher.registerProtocol("ftp", new FtpFetchProtocol());
                    fetcher.registerProtocol("rsync", new ExternalRsyncFetchProtocol());
                    auth = Authenticator.requestPasswordAuthentication(null, null, -1, null, null, null);
                    if (auth != null) {
                        fetcher.setUsername(auth.getUserName());
                        fetcher.setPassword(new String(auth.getPassword()));
                    }
                    if ((threads = config.getInt("threads", 0)) != 0) {
                        fetcher.setNumberOfThreads(threads);
                    }
                    if ((fetchRetryString = config.getString("on-failure")).equalsIgnoreCase("none")) {
                        failStrategy = StandardFailStrategies.FAIL_FAST;
                    } else if (fetchRetryString.equalsIgnoreCase("next")) {
                        failStrategy = StandardFailStrategies.ALWAYS_CONTINUE;
                    } else if (fetchRetryString.equalsIgnoreCase("retry")) {
                        failStrategy = StandardFailStrategies.ALWAYS_RETRY;
                    } else {
                        fileFailThreshold = config.getInt("max-file-failures");
                        failThreshold = config.getInt("max-failures");
                        failStrategy = new ThresholdFailStrategy(fileFailThreshold, failThreshold);
                    }
                    fetcher.setFetchFailStrategy(failStrategy);
                }
                if ("verifyvalid".equals(operation.name)) {
                    completeVerifier = new CompleteVerifierImpl();
                    completeVerifier.setMissingBagItTolerant(config.getBoolean("missingbagittolerant", false));
                    completeVerifier.setAdditionalDirectoriesInBagDirTolerant(config.getBoolean("additionaldirectorytolerant", false));
                    completeVerifier.setIgnoreSymlinks(config.getBoolean("excludesymlinks"));
                    completeVerifier.addProgressListener(listener);
                    checksumVerifier = new ParallelManifestChecksumVerifier();
                    checksumVerifier.addProgressListener(listener);
                    verifier = new ValidVerifierImpl(completeVerifier, checksumVerifier);
                    verifier.addProgressListener(listener);
                    verifier.setFailMode(FailModeSupporting.FailMode.valueOf(config.getString("failmode").toUpperCase()));
                    bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                    try {
                        result = verifier.verify((Bag)bag);
                        CommandLineBagDriver.log.info((Object)result.toString());
                        System.out.println(result.toString(SimpleResult.DEFAULT_MAX_MESSAGES, "\n"));
                        if (result.isSuccess()) ** GOTO lbl454
                        if (writeResultFile) {
                            this.writeResultFile(operation.name, result, bag.getFile());
                        }
                        ret = 1;
                    }
                    finally {
                        bag.close();
                    }
                } else if ("verifycomplete".equals(operation.name)) {
                    completeVerifier = new CompleteVerifierImpl();
                    completeVerifier.setMissingBagItTolerant(config.getBoolean("missingbagittolerant", false));
                    completeVerifier.setAdditionalDirectoriesInBagDirTolerant(config.getBoolean("additionaldirectorytolerant", false));
                    completeVerifier.setIgnoreSymlinks(config.getBoolean("excludesymlinks"));
                    completeVerifier.addProgressListener(listener);
                    completeVerifier.setFailMode(FailModeSupporting.FailMode.valueOf(config.getString("failmode").toUpperCase()));
                    bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                    try {
                        result = completeVerifier.verify(bag);
                        CommandLineBagDriver.log.info((Object)result.toString());
                        System.out.println(result.toString(SimpleResult.DEFAULT_MAX_MESSAGES, "\n"));
                        if (result.isSuccess()) ** GOTO lbl454
                        if (writeResultFile) {
                            this.writeResultFile(operation.name, result, bag.getFile());
                        }
                        ret = 1;
                    }
                    finally {
                        bag.close();
                    }
                } else if ("verifytagmanifests".equals(operation.name)) {
                    bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                    try {
                        verifier = new ParallelManifestChecksumVerifier();
                        verifier.addProgressListener(listener);
                        verifier.setFailMode(FailModeSupporting.FailMode.valueOf(config.getString("failmode").toUpperCase()));
                        result = verifier.verify(bag.getTagManifests(), bag);
                        CommandLineBagDriver.log.info((Object)result.toString());
                        System.out.println(result.toString(SimpleResult.DEFAULT_MAX_MESSAGES, "\n"));
                        if (result.isSuccess()) ** GOTO lbl454
                        if (writeResultFile) {
                            this.writeResultFile(operation.name, result, bag.getFile());
                        }
                        ret = 1;
                    }
                    finally {
                        bag.close();
                    }
                } else if ("verifypayloadmanifests".equals(operation.name)) {
                    bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                    try {
                        if (bag.getPayloadManifests().size() == 0) {
                            result = new SimpleResult(false, "Bag has no payload manifests");
                        } else {
                            verifier = new ParallelManifestChecksumVerifier();
                            verifier.addProgressListener(listener);
                            verifier.setFailMode(FailModeSupporting.FailMode.valueOf(config.getString("failmode").toUpperCase()));
                            result = verifier.verify(bag.getPayloadManifests(), bag);
                        }
                        CommandLineBagDriver.log.info((Object)result.toString());
                        System.out.println(result.toString(SimpleResult.DEFAULT_MAX_MESSAGES, "\n"));
                        if (result.isSuccess()) ** GOTO lbl454
                        if (writeResultFile) {
                            this.writeResultFile(operation.name, result, bag.getFile());
                        }
                        ret = 1;
                    }
                    finally {
                        bag.close();
                    }
                } else {
                    if ("makecomplete".equals(operation.name)) {
                        bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_FILES);
                        try {
                            newBag = completer.complete(bag);
                            try {
                                newBag.write((Writer)writer, destFile);
                                break block169;
                            }
                            finally {
                                newBag.close();
                            }
                        }
                        finally {
                            bag.close();
                        }
                    }
                    if ("update".equals(operation.name)) {
                        bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_FILES);
                        try {
                            updateCompleter = new UpdateCompleter(bagFactory);
                            updateCompleter.setTagManifestAlgorithm(Manifest.Algorithm.valueOfBagItAlgorithm(config.getString("tagmanifestalgorithm", Manifest.Algorithm.MD5.bagItAlgorithm)));
                            updateCompleter.setPayloadManifestAlgorithm(Manifest.Algorithm.valueOfBagItAlgorithm(config.getString("payloadmanifestalgorithm", Manifest.Algorithm.MD5.bagItAlgorithm)));
                            completer.setNonDefaultManifestSeparator(manifestSeparator);
                            completer.addProgressListener(listener);
                            newBag = updateCompleter.complete(bag);
                            try {
                                newBag.write((Writer)writer, destFile != null ? destFile : sourceFile);
                                break block169;
                            }
                            finally {
                                newBag.close();
                            }
                        }
                        finally {
                            bag.close();
                        }
                    }
                    if ("updatetagmanifests".equals(operation.name)) {
                        bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_FILES);
                        try {
                            tagManifestCompleter = new TagManifestCompleter(bagFactory);
                            tagManifestCompleter.setTagManifestAlgorithm(Manifest.Algorithm.valueOfBagItAlgorithm(config.getString("tagmanifestalgorithm", Manifest.Algorithm.MD5.bagItAlgorithm)));
                            tagManifestCompleter.setNonDefaultManifestSeparator(manifestSeparator);
                            newBag = tagManifestCompleter.complete(bag);
                            try {
                                for (Manifest manifest : newBag.getTagManifests()) {
                                    FileSystemHelper.write(manifest, new File(sourceFile, manifest.getFilepath()));
                                }
                                break block169;
                            }
                            finally {
                                bag.close();
                            }
                        }
                        finally {
                            bag.close();
                        }
                    }
                    if ("updatepayloadoxum".equals(operation.name)) {
                        bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_FILES);
                        try {
                            updatePayloadOxumCompleter = new UpdatePayloadOxumCompleter(bagFactory);
                            newBag = updatePayloadOxumCompleter.complete(bag);
                            try {
                                if (newBag.getBagInfoTxt() != null) {
                                    FileSystemHelper.write(newBag.getBagInfoTxt(), new File(sourceFile, newBag.getBagInfoTxt().getFilepath()));
                                }
                                for (Manifest manifest : newBag.getTagManifests()) {
                                    FileSystemHelper.write(manifest, new File(sourceFile, manifest.getFilepath()));
                                }
                                break block169;
                            }
                            finally {
                                bag.close();
                            }
                        }
                        finally {
                            bag.close();
                        }
                    }
                    if ("baginplace".equals(operation.name)) {
                        preBag = bagFactory.createPreBag(sourceFile);
                        if (config.contains("baginfotxt")) {
                            bagInfoTxtFile = config.getFile("baginfotxt");
                            if (!bagInfoTxtFile.getName().equals(bagFactory.getBagConstants().getBagInfoTxt())) {
                                msg = MessageFormat.format("External bag-info.txt must be named {0}.", new Object[]{bagFactory.getBagConstants().getBagInfoTxt()});
                                System.err.println(msg);
                                CommandLineBagDriver.log.error((Object)msg);
                                ret = 2;
                            }
                            tagFiles = new ArrayList<File>();
                            tagFiles.add((File)bagInfoTxtFile);
                            preBag.setTagFiles(tagFiles);
                        }
                        preBag.makeBagInPlace(version != null ? version : BagFactory.LATEST, config.getBoolean("retainbasedir", false), config.getBoolean("keepemptydirs", false), completer);
                    } else {
                        if ("create".equals(operation.name)) {
                            bag = this.getBag(bagFactory, sourceFile, version, null);
                            try {
                                for (String filepath : config.getStringArray("payload")) {
                                    if (filepath.endsWith(File.separator + "*")) {
                                        parentDir = new File(filepath.substring(0, filepath.length() - 2));
                                        if (!parentDir.exists()) {
                                            throw new RuntimeException(MessageFormat.format("{0} does not exist.", new Object[]{parentDir}));
                                        }
                                        if (!parentDir.isDirectory()) {
                                            throw new RuntimeException(MessageFormat.format("{0} is not a directory.", new Object[]{parentDir}));
                                        }
                                        files = parentDir.listFiles();
                                        if (files == null) continue;
                                        for (File childFile : files) {
                                            bag.addFileToPayload(childFile);
                                        }
                                        continue;
                                    }
                                    bag.addFileToPayload(new File(filepath));
                                }
                                if (config.contains("baginfotxt")) {
                                    bagInfoTxtFile = config.getFile("baginfotxt");
                                    if (!bagInfoTxtFile.getName().equals(bag.getBagConstants().getBagInfoTxt())) {
                                        msg = MessageFormat.format("External bag-info.txt must be named {0}.", new Object[]{bag.getBagConstants().getBagInfoTxt()});
                                        System.err.println(msg);
                                        CommandLineBagDriver.log.error((Object)msg);
                                        ret = 2;
                                    }
                                    bag.addFileAsTag((File)bagInfoTxtFile);
                                }
                                newBag = completer.complete(bag);
                                try {
                                    newBag.write((Writer)writer, destFile);
                                    break block169;
                                }
                                finally {
                                    newBag.close();
                                }
                            }
                            finally {
                                bag.close();
                            }
                        }
                        if ("makeholey".equals(operation.name)) {
                            puncher = new HolePuncherImpl(bagFactory);
                            bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                            try {
                                newBag = puncher.makeHoley(bag, config.getString("baseurl"), config.getBoolean("excludepayloaddir", false) == false, false, config.getBoolean("resume"));
                                try {
                                    newBag.write((Writer)writer, destFile);
                                    break block169;
                                }
                                finally {
                                    bag.close();
                                }
                            }
                            finally {
                                bag.close();
                            }
                        }
                        if ("generatepayloadoxum".equals(operation.name)) {
                            bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                            try {
                                oxum = BagHelper.generatePayloadOxum(bag);
                                CommandLineBagDriver.log.info((Object)("Payload-Oxum is " + oxum));
                                System.out.println("Payload-Oxum is " + oxum);
                            }
                            finally {
                                bag.close();
                            }
                        }
                        if ("checkpayloadoxum".equals(operation.name)) {
                            bag = this.getBag(bagFactory, sourceFile, version, BagFactory.LoadOption.BY_MANIFESTS);
                            try {
                                genOxum = BagHelper.generatePayloadOxum(bag);
                                bagInfo = bag.getBagInfoTxt();
                                if (bagInfo == null) {
                                    System.err.println("Bag does not contain bag-info.txt.");
                                    CommandLineBagDriver.log.error((Object)"Bag does not contain bag-info.txt.");
                                    ret = 2;
                                }
                                checkOxum = bagInfo.getPayloadOxum();
                                if (checkOxum == null) {
                                    System.err.println("bag-info.txt does not contain Payload-Oxum.");
                                    CommandLineBagDriver.log.error((Object)"bag-info.txt does not contain Payload-Oxum.");
                                    ret = 2;
                                }
                                if (checkOxum.equals(genOxum)) {
                                    oxumMsg = "Payload-Oxum matches.";
                                    System.out.println(oxumMsg);
                                    CommandLineBagDriver.log.info((Object)oxumMsg);
                                }
                                oxumMsg = MessageFormat.format("Payload-Oxum does not match. Expected {0} according to bag-info.txt but found {1}.", new Object[]{checkOxum, genOxum});
                                System.out.println(oxumMsg);
                                CommandLineBagDriver.log.info((Object)oxumMsg);
                                ret = 1;
                            }
                            finally {
                                bag.close();
                            }
                        } else if ("fillholey".equals(operation.name)) {
                            dest = new FileSystemFileDestination(sourceFile);
                            bag = this.getBag(bagFactory, sourceFile, version, null);
                            try {
                                result = fetcher.fetch(bag, dest, config.getBoolean("resume"), config.getBoolean("verify"));
                                CommandLineBagDriver.log.info((Object)result.toString());
                                System.out.println(result.toString(SimpleResult.DEFAULT_MAX_MESSAGES, "\n"));
                                if (result.isSuccess()) ** GOTO lbl454
                                if (writeResultFile) {
                                    this.writeResultFile(operation.name, result, bag.getFile());
                                }
                                ret = 1;
                            }
                            finally {
                                bag.close();
                            }
                        } else if ("retrieve".equals(operation.name)) {
                            result = fetcher.fetchRemoteBag(destFile, config.getString("url"), config.getBoolean("resume"), config.getBoolean("verify"));
                            CommandLineBagDriver.log.info((Object)result.toString());
                            System.out.println(result.toString(SimpleResult.DEFAULT_MAX_MESSAGES, "\n"));
                            if (!result.isSuccess()) {
                                if (writeResultFile) {
                                    this.writeResultFile(operation.name, result, destFile);
                                }
                                ret = 1;
                            }
                        } else if ("splitbagbysize".equals(operation.name) || "splitbagbyfiletype".equals(operation.name) || "splitbagbysizeandfiletype".equals(operation.name)) {
                            srcBag = bagFactory.createBag(sourceFile, BagFactory.LoadOption.BY_FILES);
                            try {
                                sourceBagSize = null;
                                if (srcBag.getBagInfoTxt() != null && srcBag.getBagInfoTxt().getPayloadOxum() != null) {
                                    sourceBagSize = new Double(srcBag.getBagInfoTxt().getPayloadOxum());
                                }
                                destBagFile = destFile == null ? new File(srcBag.getFile() + "_split") : destFile;
                                maxBagSizeInGB = config.contains("maxbagsize") != false ? config.getDouble("maxbagsize") : 300.0;
                                maxBagSize = 300.0 * SizeHelper.GB;
                                fileExtensions = config.contains("fileextensions") != false ? config.getString("fileextensions").split(",") : null;
                                fileExtensionsIn = null;
                                if (fileExtensions != null && fileExtensions.length > 0) {
                                    fileExtensionsIn = new String[fileExtensions.length][];
                                    for (i = 0; i < fileExtensions.length; ++i) {
                                        fileExtensionsIn[i] = fileExtensions[i].split(":");
                                    }
                                }
                                excludeDirs = config.contains("excludedirs") != false ? config.getString("excludedirs").split(",") : null;
                                keepLowestLevelDir = config.getBoolean("keeplowestleveldir", false);
                                if ("splitbagbysize".equals(operation.name)) {
                                    if (sourceBagSize != null && sourceBagSize <= maxBagSizeInGB * SizeHelper.GB) {
                                        System.out.println("Max bag size should not be greater than the source bag size.");
                                        var24_40 = 1;
                                        return var24_40;
                                    }
                                    splitter = new SplitBySize(bagFactory, maxBagSize, keepLowestLevelDir, excludeDirs);
                                    splitBags = splitter.split(srcBag);
                                    try {
                                        this.completeAndWriteBagToDisk(splitBags, completer, (Writer)writer, srcBag, destBagFile, true);
                                    }
                                    finally {
                                        for (Bag bag : splitBags) {
                                            bag.close();
                                        }
                                        break block169;
                                    }
                                }
                                if ("splitbagbyfiletype".equals(operation.name)) {
                                    if (fileExtensionsIn == null) {
                                        System.out.println("File extensions should not be null or empty.");
                                        splitter = 1;
                                        return splitter;
                                    }
                                    splitter = new SplitByFileType(bagFactory, fileExtensionsIn, excludeDirs);
                                    splitBags = splitter.split(srcBag);
                                    try {
                                        this.completeAndWriteBagToDisk(splitBags, completer, (Writer)writer, srcBag, destBagFile, false);
                                    }
                                    finally {
                                        for (Bag bag : splitBags) {
                                            bag.close();
                                        }
                                        break block169;
                                    }
                                }
                                if (!"splitbagbysizeandfiletype".equals(operation.name)) break block169;
                                if (fileExtensionsIn == null) {
                                    System.out.println("File extensions should not be null or empty.");
                                    splitter = 1;
                                    return splitter;
                                }
                                splitter1 = new SplitByFileType(bagFactory, fileExtensionsIn, excludeDirs);
                                bags = splitter1.split(srcBag);
                                splitter2 = new SplitBySize(bagFactory, maxBagSize, keepLowestLevelDir, excludeDirs);
                                try {
                                    for (Bag bag : bags) {
                                        bagsUnderMaxSize = new ArrayList<Bag>();
                                        v1 = new Double(bag.getBagInfoTxt().getPayloadOxum());
                                        if (v1 <= maxBagSizeInGB * SizeHelper.GB) {
                                            bagsUnderMaxSize.add(bag);
                                        } else {
                                            bags2 = splitter2.split(bag);
                                            try {
                                                this.completeAndWriteBagToDisk(bags2, completer, (Writer)writer, srcBag, destBagFile, true);
                                            }
                                            finally {
                                                var31_66 = bags2.iterator();
                                                while (true) {
                                                    if (!var31_66.hasNext()) {
                                                    }
                                                    bag2 = var31_66.next();
                                                    bag2.close();
                                                }
                                            }
                                        }
                                        this.completeAndWriteBagToDisk(bagsUnderMaxSize, completer, (Writer)writer, srcBag, destBagFile, true);
                                    }
                                }
                                finally {
                                    for (Bag bag : bags) {
                                        bag.close();
                                    }
                                }
                            }
                            finally {
                                srcBag.close();
                            }
                        }
                    }
                }
            }
            CommandLineBagDriver.log.info((Object)"Operation completed.");
            return ret;
        }
        catch (IOException ex) {
            CommandLineBagDriver.log.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
            return 2;
        }
        catch (BagTransferException ex) {
            CommandLineBagDriver.log.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
            return 2;
        }
        catch (RuntimeException ex) {
            CommandLineBagDriver.log.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
            return 2;
        }
    }

    private void completeAndWriteBagToDisk(List<Bag> bags, Completer completer, Writer writer, Bag srcBag, File destBagFile, boolean appendNumber) {
        BagFactory bagFactory = srcBag.getBagFactory();
        int i = 0;
        for (Bag bag : bags) {
            Bag newBag = completer.complete(bag);
            StringBuffer bagName = new StringBuffer();
            bagName.append(srcBag.getFile().getName());
            if (newBag.getBagInfoTxt().get("File-Type") != null) {
                bagName.append("_").append(((String)newBag.getBagInfoTxt().get("File-Type")).replaceAll(" ", "_"));
            }
            if (appendNumber && bags.size() > 1) {
                bagName.append("_").append(i);
            }
            newBag.write(writer == null ? new FileSystemWriter(bagFactory) : writer, new File(destBagFile, bagName.toString()));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeResultFile(String operation, SimpleResult result, File bagFile) {
        if (result.isSuccess()) {
            return;
        }
        String filename = MessageFormat.format("{0}-{1}.txt", operation, System.getProperty("log.timestamp"));
        if (bagFile != null) {
            filename = MessageFormat.format("{0}-{1}", bagFile.getName(), filename);
        }
        File file = new File(filename);
        BufferedWriter writer = null;
        try {
            writer = Files.newBufferedWriter(Paths.get(file.toURI()), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            for (String msg : result.getMessages()) {
                writer.write(msg + "\n");
            }
            System.out.println("Complete results written to " + file.getCanonicalPath());
            if (writer == null) return;
        }
        catch (IOException e) {
            log.error((Object)"Unable to write results", (Throwable)e);
            return;
        }
        finally {
            if (writer != null) {
                IOUtils.closeQuietly(writer);
            }
        }
        IOUtils.closeQuietly((java.io.Writer)writer);
        return;
    }

    private static class Operation {
        public String help;
        public JSAP jsap;
        public String name;
        public String[] examples;

        public Operation(String name, JSAP jsap, String help, String[] examples) {
            this.name = name;
            this.help = help;
            this.jsap = jsap;
            this.examples = examples;
        }
    }
}

