/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.FetchTxtWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchTxtWriterImpl
implements FetchTxtWriter {
    private static final Log log = LogFactory.getLog(FetchTxtWriterImpl.class);
    public static final String SEPARATOR = "  ";
    private PrintWriter writer = null;

    public FetchTxtWriterImpl(OutputStream out) {
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), true);
    }

    @Override
    public void write(String filename, Long size, String url, FetchTxt.FetchStatus fetchStatus) {
        String sizeString = "-";
        if (size != null) {
            sizeString = size.toString();
        }
        try {
            String newUrl = url.replaceAll(" ", "%20");
            StringBuilder sb = new StringBuilder();
            sb.append(newUrl).append(SEPARATOR).append(sizeString);
            if (fetchStatus != null) {
                sb.append(SEPARATOR).append(fetchStatus.toString());
            }
            sb.append(SEPARATOR).append(filename);
            this.writer.println(sb.toString());
            log.debug((Object)MessageFormat.format("Filename is {0}.  Size is {1}. Url is {2}.  Fetch status is {3}.", new Object[]{filename, size, newUrl, fetchStatus}));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

