/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer;

import gov.loc.repository.bagit.FetchTxt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FetchTarget
implements Comparable<FetchTarget> {
    private ArrayList<FetchTxt.FilenameSizeUrl> fetchLines;
    private String path;
    private Long size;
    private FetchResult fetchResult = FetchResult.NOT_FETCHED;

    public String getFilename() {
        return this.path;
    }

    public Long getSize() {
        return this.size;
    }

    public FetchResult getFetchResult() {
        return this.fetchResult;
    }

    public void setFetchResult(FetchResult fetchResult) {
        this.fetchResult = fetchResult;
    }

    public List<FetchTxt.FilenameSizeUrl> getLines() {
        return Collections.unmodifiableList(this.fetchLines);
    }

    public FetchTarget(FetchTxt.FilenameSizeUrl target, FetchResult fetchResult, FetchTxt.FilenameSizeUrl ... targets) {
        this.fetchLines = new ArrayList(targets.length + 1);
        this.path = target.getFilename();
        this.size = target.getSize();
        this.fetchResult = fetchResult;
        this.addLine(target);
        for (int i = 0; i < targets.length; ++i) {
            this.addLine(targets[i]);
        }
    }

    public void addLine(FetchTxt.FilenameSizeUrl line) {
        this.validateLine(line);
        this.fetchLines.add(line);
    }

    private void validateLine(FetchTxt.FilenameSizeUrl line) {
        if (!line.getFilename().equals(this.path) || this.size == null && line.getSize() != null || this.size != null && !this.size.equals(line.getSize())) {
            throw new IllegalArgumentException("All given fetch targets must have the same file name and size.");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchTarget other = (FetchTarget)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public int compareTo(FetchTarget fetchTarget) {
        return this.path.compareTo(fetchTarget.path);
    }

    public static enum FetchResult {
        NOT_FETCHED,
        FETCH_FAILED,
        VERIFY_FAILED,
        VERIFY_SUCCEEDED;

    }
}

