/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.filesystem.FileNode;
import gov.loc.repository.bagit.filesystem.impl.FileFileNode;
import gov.loc.repository.bagit.filesystem.impl.FileFileSystem;
import gov.loc.repository.bagit.impl.FileBagFile;
import gov.loc.repository.bagit.impl.FileSystemBagFile;
import gov.loc.repository.bagit.utilities.FileHelper;
import gov.loc.repository.bagit.utilities.FilenameHelper;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import gov.loc.repository.bagit.writer.impl.AbstractWriter;
import gov.loc.repository.bagit.writer.impl.FileSystemHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSystemWriter
extends AbstractWriter {
    private static final Log log = LogFactory.getLog(FileSystemWriter.class);
    private File newBagDir;
    private boolean skipIfPayloadFileExists = true;
    private boolean ignoreNfsTmpFiles = true;
    private Bag origBag;
    private Bag newBag;
    private FileFileSystem fileSystem;
    private int fileTotal = 0;
    private int fileCount = 0;
    private boolean tagFilesOnly = false;
    private boolean filesThatDoNotMatchManifestOnly = false;
    private WriteMode writeMode = WriteMode.COPY;

    public FileSystemWriter(BagFactory bagFactory) {
        super(bagFactory);
    }

    @Override
    protected Bag.Format getFormat() {
        return Bag.Format.FILESYSTEM;
    }

    public void setFilesThatDoNotMatchManifestOnly(boolean filesThatDoNotMatchManifestOnly) {
        this.filesThatDoNotMatchManifestOnly = filesThatDoNotMatchManifestOnly;
    }

    public void setTagFilesOnly(boolean tagFilesOnly) {
        this.tagFilesOnly = tagFilesOnly;
    }

    public void setIgnoreNfsTmpFiles(boolean ignore) {
        this.ignoreNfsTmpFiles = ignore;
    }

    public void setSkipIfPayloadFileExists(boolean skip) {
        this.skipIfPayloadFileExists = skip;
    }

    public void setPayloadWriteMode(WriteMode writeMode) {
        this.writeMode = writeMode;
    }

    @Override
    public void startBag(Bag bag) {
        try {
            if (this.newBagDir.exists()) {
                if (!this.newBagDir.isDirectory()) {
                    throw new RuntimeException(MessageFormat.format("Bag directory {0} is not a directory.", this.newBagDir.toString()));
                }
            } else {
                FileUtils.forceMkdir((File)this.newBagDir);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.newBag = this.bagFactory.createBag(this.newBagDir, bag.getBagConstants().getVersion(), BagFactory.LoadOption.NO_LOAD);
        this.fileSystem = new FileFileSystem(this.newBagDir, bag.getBagFactory().getDefaultNodeFilter());
        this.fileCount = 0;
        this.fileTotal = bag.getTags().size() + bag.getPayload().size();
        this.origBag = bag;
    }

    @Override
    public void visitPayload(BagFile bagFile) {
        File file = new File(this.newBagDir, bagFile.getFilepath());
        if (!(this.tagFilesOnly || this.skipIfPayloadFileExists && file.exists() || this.filesThatDoNotMatchManifestOnly && this.fileMatchesManifest(bagFile, file))) {
            FileNode fileNode;
            ++this.fileCount;
            this.progress("writing", bagFile.getFilepath(), this.fileCount, this.fileTotal);
            log.debug((Object)MessageFormat.format("Writing payload file {0} to {1}.", bagFile.getFilepath(), file.toString()));
            File sourceFile = null;
            if (bagFile instanceof FileBagFile) {
                sourceFile = ((FileBagFile)bagFile).getFile();
            } else if (bagFile instanceof FileSystemBagFile && (fileNode = ((FileSystemBagFile)bagFile).getFileNode()) instanceof FileFileNode) {
                sourceFile = ((FileFileNode)fileNode).getFile();
            }
            if (sourceFile != null && WriteMode.COPY.equals((Object)this.writeMode)) {
                if (!file.equals(sourceFile)) {
                    log.debug((Object)MessageFormat.format("Copying {0} to {1}", sourceFile, file));
                    FileSystemHelper.copy(sourceFile, file);
                } else {
                    log.trace((Object)MessageFormat.format("Not copying {0} because source is the same as destination", file));
                }
            } else if (sourceFile != null && WriteMode.MOVE.equals((Object)this.writeMode)) {
                if (!file.equals(sourceFile)) {
                    log.debug((Object)MessageFormat.format("Moving {0} to {1}", sourceFile, file));
                    FileSystemHelper.move(sourceFile, file);
                } else {
                    log.trace((Object)MessageFormat.format("Not moving {0} because source is the same as destination", file));
                }
            } else {
                FileSystemHelper.write(bagFile, file);
            }
        } else {
            log.debug((Object)MessageFormat.format("Skipping writing payload file {0} to {1}.", bagFile.getFilepath(), file.toString()));
        }
        this.newBag.putBagFile(new FileSystemBagFile(bagFile.getFilepath(), this.fileSystem.resolve(bagFile.getFilepath())));
    }

    @Override
    public void visitTag(BagFile bagFile) {
        ++this.fileCount;
        this.progress("writing", bagFile.getFilepath(), this.fileCount, this.fileTotal);
        File file = new File(this.newBagDir, bagFile.getFilepath());
        if (!this.filesThatDoNotMatchManifestOnly || !this.fileMatchesManifest(bagFile, file)) {
            log.debug((Object)MessageFormat.format("Writing tag file {0} to {1}.", bagFile.getFilepath(), file.toString()));
            FileSystemHelper.write(bagFile, file);
        } else {
            log.debug((Object)MessageFormat.format("Skipping writing tag file {0} to {1}.", bagFile.getFilepath(), file.toString()));
        }
        this.newBag.putBagFile(new FileSystemBagFile(bagFile.getFilepath(), this.fileSystem.resolve(bagFile.getFilepath())));
    }

    @Override
    public Bag write(Bag bag, File file) {
        log.info((Object)"Writing bag");
        this.newBagDir = FileHelper.normalizeForm(file);
        bag.accept(this);
        if (this.newBagDir.equals(bag.getFile())) {
            log.debug((Object)"Removing any extra files or directories");
            this.removeExtraFiles(this.newBagDir, false);
            if (!this.tagFilesOnly) {
                this.removeExtraFiles(new File(this.newBagDir, bag.getBagConstants().getDataDirectory()), true);
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        return this.newBag;
    }

    private void removeExtraFiles(File dir, boolean recurse) {
        log.trace((Object)MessageFormat.format("Checking children of {0} for removal", dir));
        File[] files = FileHelper.normalizeForm(dir.listFiles());
        if (files != null) {
            for (File file : files) {
                if (this.isCancelled()) {
                    return;
                }
                if (file.isDirectory()) {
                    this.removeDirectory(file, recurse);
                    continue;
                }
                this.removeFile(file);
            }
        } else {
            log.warn((Object)("Directory [" + dir + "] is empty, skipping."));
        }
    }

    private void removeDirectory(File file, boolean recurse) {
        File[] files;
        if (log.isTraceEnabled()) {
            files = file.listFiles();
            log.trace((Object)MessageFormat.format("{0} is a directory with {1} children", file, files == null ? 0 : files.length));
        }
        if (recurse) {
            this.removeExtraFiles(file, recurse);
            if (log.isTraceEnabled()) {
                files = file.listFiles();
                log.trace((Object)MessageFormat.format("{0} now has {1} children", file, files == null ? 0 : files.length));
            }
        }
    }

    private void removeFile(File file) {
        String filepath = FilenameHelper.removeBasePath(this.newBagDir.toString(), file.toString());
        log.trace((Object)MessageFormat.format("{0} is a file whose filepath is {1}", file, filepath));
        if (this.newBag.getBagFile(filepath) == null) {
            if (!this.ignoreNfsTmpFiles || !file.getName().startsWith(".nfs")) {
                try {
                    log.trace((Object)("Deleting " + file));
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                log.warn((Object)("Ignoring nfs temp file: " + file));
            }
        }
    }

    private boolean fileMatchesManifest(BagFile bagFile, File file) {
        Map<Manifest.Algorithm, String> checksumMap = this.origBag.getChecksums(bagFile.getFilepath());
        boolean res = false;
        if (file.exists() && !checksumMap.isEmpty()) {
            Map.Entry<Manifest.Algorithm, String> entry = checksumMap.entrySet().iterator().next();
            try {
                res = MessageDigestHelper.fixityMatches(new FileInputStream(file), entry.getKey(), entry.getValue());
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Error reading " + file.getPath(), e);
            }
        }
        log.trace((Object)MessageFormat.format("Result of checking that {0} matches manifest is {1}", bagFile.getFilepath(), res));
        return res;
    }

    public static enum WriteMode {
        STREAM,
        COPY,
        MOVE;

    }
}

