/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import cool.pandora.modeller.bag.BaggerFileEntity;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.handlers.base.BagTreeTransferHandler;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagTree
extends JTree {
    private static final long serialVersionUID = -5361474872106399068L;
    protected static final Logger log = LoggerFactory.getLogger(BagTree.class);
    private final int BAGTREE_WIDTH = 400;
    private int BAGTREE_HEIGHT = 160;
    private int BAGTREE_ROW_MODIFIER = 22;
    private String basePath;
    private DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode("data");
    private final ArrayList<DefaultMutableTreeNode> srcNodes = new ArrayList();

    public BagTree(BagView bagView, String path) {
        this.setShowsRootHandles(true);
        this.basePath = path;
        this.parentNode = new DefaultMutableTreeNode(this.basePath);
        this.initialize();
        this.initListeners();
        JTextField nameTextField = new JTextField();
        this.BAGTREE_ROW_MODIFIER = nameTextField.getFontMetrics(nameTextField.getFont()).getHeight() + 5;
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new BagTreeTransferHandler());
        this.getSelectionModel().setSelectionMode(2);
        bagView.registerTreeListener(path, this);
    }

    private void initialize() {
        this.setModel(new DefaultTreeModel(this.parentNode));
        TreePath rootPath = new TreePath(this.parentNode.getPath());
        this.setAnchorSelectionPath(rootPath);
        this.makeVisible(rootPath);
        this.setLargeModel(true);
        this.requestFocus();
        this.setScrollsOnExpand(true);
    }

    public void populateNodes(DefaultBag bag, String path, File rootSrc) {
        this.basePath = path;
        log.debug("BagTree.populateNodes");
        if (bag.getPayload() != null && rootSrc.listFiles() != null) {
            this.addNodes(rootSrc, true);
        } else {
            List payload;
            log.debug("BagTree.populateNodes listFiles NULL:");
            if (!bag.isHoley()) {
                log.debug("BagTree.populateNodes getPayloadPaths:");
                payload = bag.getPayloadPaths();
            } else {
                log.debug("BagTree.populateNodes getFetchPayload:");
                payload = bag.getPayloadPaths();
            }
            for (String filePath : payload) {
                try {
                    String normalPath = bag.isHoley() ? BaggerFileEntity.removeBasePath((String)"data", (String)filePath) : BaggerFileEntity.removeBasePath((String)this.basePath, (String)filePath);
                    if (this.nodeAlreadyExists(normalPath)) continue;
                    this.addNode(normalPath);
                }
                catch (Exception e) {
                    if (!this.nodeAlreadyExists(filePath)) {
                        this.addNode(filePath);
                    }
                    log.error("Failed to remove base path from {}", (Object)filePath, (Object)e);
                }
            }
            log.debug("BagTree rows: {}", (Object)payload.size());
            this.BAGTREE_HEIGHT = this.BAGTREE_ROW_MODIFIER * (payload.size() + 1);
            this.setPreferredSize(this.getTreeSize());
            this.invalidate();
        }
    }

    public boolean addNodes(File file, boolean isParent) {
        if (!this.nodeAlreadyExists(file.getName())) {
            DefaultMutableTreeNode rootNode = BagTree.createNodeTree(null, null, file);
            this.srcNodes.add(rootNode);
            if (isParent) {
                this.parentNode = rootNode;
            } else {
                this.parentNode.add(rootNode);
            }
        } else {
            return true;
        }
        this.initialize();
        return false;
    }

    private boolean nodeAlreadyExists(String path) {
        DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(path);
        String node = aNode.toString();
        boolean isNodeChild = this.parentNode.isNodeChild(aNode);
        if (isNodeChild) {
            return true;
        }
        for (int i = 0; i < this.parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)this.parentNode.getChildAt(i);
            String child = childNode.toString();
            if (!child.equalsIgnoreCase(node)) continue;
            isNodeChild = true;
            break;
        }
        return isNodeChild;
    }

    public void addNode(String filePath) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(filePath);
        this.srcNodes.add(node);
        this.parentNode.add(node);
        this.initialize();
    }

    private static DefaultMutableTreeNode createNodeTree(DefaultMutableTreeNode curTop, DefaultMutableTreeNode displayTop, File dir) {
        String curPath = dir.getPath();
        String displayPath = dir.getName();
        DefaultMutableTreeNode curDir = new DefaultMutableTreeNode(curPath);
        DefaultMutableTreeNode displayDir = new DefaultMutableTreeNode(displayPath);
        if (curTop != null) {
            curTop.add(curDir);
            displayTop.add(displayDir);
        }
        Vector<String> ol = new Vector<String>();
        String[] tmp = dir.list();
        if (tmp != null && tmp.length > 0) {
            for (String aTmp : tmp) {
                ol.addElement(aTmp);
            }
        }
        ol.sort(String.CASE_INSENSITIVE_ORDER);
        Vector<String> files = new Vector<String>();
        for (int i = 0; i < ol.size(); ++i) {
            String thisObject = (String)ol.elementAt(i);
            String newPath = curPath.equals(".") ? thisObject : curPath + File.separator + thisObject;
            File f = new File(newPath);
            if (f.isDirectory()) {
                BagTree.createNodeTree(curDir, displayDir, f);
                continue;
            }
            files.addElement(thisObject);
        }
        for (int fnum = 0; fnum < files.size(); ++fnum) {
            String elem = (String)files.elementAt(fnum);
            DefaultMutableTreeNode elemNode = new DefaultMutableTreeNode(elem);
            curDir.add(elemNode);
            displayDir.add(elemNode);
        }
        return displayDir;
    }

    Dimension getTreeSize() {
        return new Dimension(400, this.BAGTREE_HEIGHT);
    }

    private void initListeners() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                int rows = BagTree.this.BAGTREE_ROW_MODIFIER * BagTree.this.getRowCount();
                log.trace("BagTree rows: {}", (Object)rows);
                BagTree.this.setPreferredSize(new Dimension(400, rows));
                BagTree.this.invalidate();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                int rows = BagTree.this.BAGTREE_ROW_MODIFIER * BagTree.this.getRowCount();
                log.trace("BagTree rows: {}", (Object)rows);
                BagTree.this.setPreferredSize(new Dimension(400, rows));
                BagTree.this.invalidate();
            }
        });
    }
}

