/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui;

import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.SwingWorker;
import gov.loc.repository.bagit.ProgressListener;
import java.text.MessageFormat;
import javax.swing.ProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongTask
implements ProgressListener {
    protected static final Logger log = LoggerFactory.getLogger(LongTask.class);
    private boolean done = false;
    private Progress progress;
    private ProgressMonitor progressMonitor;
    private String activityMonitored;

    public void setMonitor(ProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void go() {
        SwingWorker worker = new SwingWorker(this){

            @Override
            public Object construct() {
                LongTask.this.done = false;
                this.longTask.progress.execute();
                return new Object();
            }

            @Override
            public void finished() {
            }
        };
        worker.start();
    }

    public boolean hasUserTriedToCancel() {
        return this.progressMonitor.isCanceled();
    }

    public boolean isDone() {
        return this.done;
    }

    public void done() {
        this.done = true;
        this.progressMonitor.close();
    }

    public synchronized void reportProgress(String activity, Object item, Long count, Long total) {
        if (count == null || total == null) {
            log.error("reportProgress received null info: count={}, total={}", (Object)count, (Object)total);
        } else if (this.activityMonitored == null || this.activityMonitored.equals(activity)) {
            String message = MessageFormat.format("{0} ({2} of {3}) {1} ", activity, item, count, total);
            this.progressMonitor.setNote(message);
            this.progressMonitor.setMaximum(total.intValue());
            this.progressMonitor.setProgress(count.intValue());
        }
    }

    public synchronized void setActivityMonitored(String activityMonitored) {
        this.activityMonitored = activityMonitored;
    }
}

