/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagTreeTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(BagTreeTransferHandler.class);
    private static final DataFlavor uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String", null);
    private DataFlavor nodesFlavor;
    private final DataFlavor[] flavors = new DataFlavor[1];
    private DefaultMutableTreeNode[] nodesToRemove;

    public BagTreeTransferHandler() {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + DefaultMutableTreeNode[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to construct a nodeFlavor", (Throwable)e);
        }
    }

    private static void display(String s) {
        String msg = "BagTreeTransferHandler." + s;
        log.info(msg);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (DataFlavor transferFlavor : transferFlavors) {
            Class<?> representationclass = transferFlavor.getRepresentationClass();
            if (representationclass != null && URL.class.isAssignableFrom(representationclass)) {
                return true;
            }
            if (DataFlavor.javaFileListFlavor.equals(transferFlavor)) {
                return true;
            }
            if (DataFlavor.stringFlavor.equals(transferFlavor)) {
                return true;
            }
            if (!uriListFlavor.equals(transferFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            DefaultMutableTreeNode next;
            ArrayList<DefaultMutableTreeNode> copies = new ArrayList<DefaultMutableTreeNode>();
            ArrayList<DefaultMutableTreeNode> toRemove = new ArrayList<DefaultMutableTreeNode>();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
            DefaultMutableTreeNode copy = BagTreeTransferHandler.copy(node);
            copies.add(copy);
            toRemove.add(node);
            for (int i = 1; i < paths.length && (next = (DefaultMutableTreeNode)paths[i].getLastPathComponent()).getLevel() >= node.getLevel(); ++i) {
                if (next.getLevel() > node.getLevel()) {
                    copy.add(BagTreeTransferHandler.copy(next));
                    continue;
                }
                copies.add(BagTreeTransferHandler.copy(next));
                toRemove.add(next);
            }
            DefaultMutableTreeNode[] nodes = copies.toArray(new DefaultMutableTreeNode[copies.size()]);
            this.nodesToRemove = toRemove.toArray(new DefaultMutableTreeNode[toRemove.size()]);
            return new NodesTransferable(nodes);
        }
        return null;
    }

    private static DefaultMutableTreeNode copy(TreeNode node) {
        return new DefaultMutableTreeNode(node);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        JTree tree = (JTree)source;
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        for (DefaultMutableTreeNode aNodesToRemove : this.nodesToRemove) {
            BagTreeTransferHandler.display("exportDonevnodesToRemove: " + aNodesToRemove);
            model.removeNodeFromParent(aNodesToRemove);
        }
    }

    public class NodesTransferable
    implements Transferable {
        DefaultMutableTreeNode[] nodes;

        NodesTransferable(DefaultMutableTreeNode[] nodes) {
            this.nodes = (DefaultMutableTreeNode[])nodes.clone();
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes.clone();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return BagTreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return BagTreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

