/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.BagTree;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.dialog.ConfirmationDialog;

public class ClearBagHandler
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    BagView bagView;
    private boolean confirmSaveFlag = false;

    public ClearBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.closeExistingBag();
    }

    void closeExistingBag() {
        if (this.bagView.getBag().isHoley() || this.bagView.getBag().isSerial()) {
            this.clearExistingBag();
        } else {
            this.confirmCloseBag();
        }
        if (this.isConfirmSaveFlag()) {
            this.bagView.saveBagHandler.setClearAfterSaving(true);
            this.bagView.saveBagAsHandler.openSaveBagAsFrame();
            this.setConfirmSaveFlag(false);
        }
    }

    private void confirmCloseBag() {
        ConfirmationDialog dialog = new ConfirmationDialog(){

            protected void onConfirm() {
                ClearBagHandler.this.setConfirmSaveFlag(true);
            }

            protected void onCancel() {
                super.onCancel();
                ClearBagHandler.this.clearExistingBag();
            }
        };
        dialog.setCloseAction(CloseAction.DISPOSE);
        dialog.setTitle(this.bagView.getPropertyMessage("bag.dialog.title.close"));
        dialog.setConfirmationMessage(this.bagView.getPropertyMessage("bag.dialog.message.close"));
        dialog.showDialog();
    }

    void clearExistingBag() {
        this.newDefaultBag(null);
        DefaultBag bag = this.bagView.getBag();
        bag.clear();
        this.bagView.baggerRules.clear();
        this.bagView.bagPayloadTree = new BagTree(this.bagView, "data");
        this.bagView.bagPayloadTreePanel.refresh(this.bagView.bagPayloadTree);
        this.bagView.bagTagFileTree = new BagTree(this.bagView, ApplicationContextUtil.getMessage("bag.label.noname"));
        this.bagView.bagTagFileTreePanel.refresh(this.bagView.bagTagFileTree);
        this.bagView.infoInputPane.setBagName(bag.getName());
        this.bagView.infoInputPane.updateInfoForms();
        this.bagView.updateClearBag();
    }

    void newDefaultBag(File f) {
        String bagName;
        DefaultBag bag;
        try {
            bag = new DefaultBag(f, this.bagView.infoInputPane.getBagVersion());
        }
        catch (Exception e) {
            bag = new DefaultBag(f, null);
        }
        if (f == null) {
            bagName = this.bagView.getPropertyMessage("bag.label.noname");
        } else {
            bagName = f.getName();
            String fileName = f.getAbsolutePath();
            this.bagView.infoInputPane.setBagName(fileName);
        }
        bag.setName(bagName);
        this.bagView.setBag(bag);
    }

    private void setConfirmSaveFlag(boolean confirmSaveFlag) {
        this.confirmSaveFlag = confirmSaveFlag;
    }

    private boolean isConfirmSaveFlag() {
        return this.confirmSaveFlag;
    }
}

