/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenBagHandler
extends AbstractAction {
    protected static final Logger log = LoggerFactory.getLogger(OpenBagHandler.class);
    private static final long serialVersionUID = 1L;
    BagView bagView;

    public OpenBagHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openBag();
    }

    void openBag() {
        File selectFile = new File(File.separator + ".");
        JFrame frame = new JFrame();
        JFileChooser fo = new JFileChooser(selectFile);
        fo.setDialogType(0);
        fo.setFileSelectionMode(2);
        if (this.bagView.getBagRootPath() != null) {
            fo.setCurrentDirectory(this.bagView.getBagRootPath().getParentFile());
        }
        fo.setDialogTitle("Existing Bag Location");
        int option = fo.showOpenDialog(frame);
        if (option == 0) {
            File file = fo.getSelectedFile();
            if (file == null) {
                file = this.bagView.getBagRootPath();
            }
            this.openExistingBag(file);
        }
    }

    void openExistingBag(File file) {
        File rootSrc;
        String path;
        this.bagView.infoInputPane.bagInfoInputPane.enableForms(true);
        this.bagView.clearBagHandler.clearExistingBag();
        try {
            this.bagView.clearBagHandler.newDefaultBag(file);
            ApplicationContextUtil.addConsoleMessage("Opened the bag " + file.getAbsolutePath());
        }
        catch (Exception ex) {
            ApplicationContextUtil.addConsoleMessage("Failed to create bag message: " + ex.getMessage());
            ApplicationContextUtil.addConsoleMessage("Failed to create bag exception: " + ex);
            log.error("Failed to create bag", (Throwable)ex);
            return;
        }
        DefaultBag bag = this.bagView.getBag();
        this.bagView.infoInputPane.setBagVersion(bag.getVersion());
        this.bagView.infoInputPane.setProfile(bag.getProfile().getName());
        String fileName = file.getAbsolutePath();
        this.bagView.infoInputPane.setBagName(fileName);
        String s = file.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            String sub = s.substring(i + 1).toLowerCase();
            if (sub.contains("zip")) {
                this.bagView.infoInputPane.serializeValue.setText("zip");
                bag.setSerialMode((short)1);
                bag.isSerial(true);
            } else {
                this.bagView.infoInputPane.serializeValue.setText("none");
                bag.setSerialMode((short)0);
                bag.isSerial(false);
            }
        } else {
            this.bagView.infoInputPane.serializeValue.setText("none");
            bag.setSerialMode((short)0);
            bag.isSerial(false);
        }
        this.bagView.infoInputPane.serializeValue.invalidate();
        if (bag.isHoley()) {
            this.bagView.infoInputPane.setHoley("true");
        } else {
            this.bagView.infoInputPane.setHoley("false");
        }
        this.bagView.infoInputPane.holeyValue.invalidate();
        this.bagView.updateBaggerRules();
        this.bagView.setBagRootPath(file);
        if (bag.getFetchTxt() != null) {
            path = bag.getFetch().getBaseURL();
            rootSrc = new File(file, bag.getFetchTxt().getFilepath());
        } else {
            path = "data";
            rootSrc = new File(file, bag.getDataDirectory());
        }
        this.bagView.bagPayloadTree.populateNodes(bag, path, rootSrc);
        this.bagView.bagPayloadTreePanel.refresh(this.bagView.bagPayloadTree);
        this.bagView.updateManifestPane();
        this.bagView.enableBagSettings(true);
        String msgs = bag.validateMetadata();
        if (msgs != null) {
            ApplicationContextUtil.addConsoleMessage(msgs);
        }
        this.bagView.infoInputPane.bagInfoInputPane.populateForms(bag);
        this.bagView.updateOpenBag();
        BagView.statusBarEnd();
    }
}

