/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.base;

import cool.pandora.modeller.bag.BaggerFileEntity;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveDataHandler
extends AbstractAction {
    protected static final Logger log = LoggerFactory.getLogger(RemoveDataHandler.class);
    private static final long serialVersionUID = 1L;
    BagView bagView;

    public RemoveDataHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeData();
    }

    private void removeData() {
        DefaultBag bag = this.bagView.getBag();
        TreePath[] paths = this.bagView.bagPayloadTree.getSelectionPaths();
        if (paths != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.bagView.bagPayloadTree.getModel();
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                log.debug("removeData: {}", (Object)path.toString());
                log.debug("removeData pathCount: {}", (Object)path.getPathCount());
                File filePath = null;
                String fileName = null;
                if (path.getPathCount() > 0) {
                    filePath = new File("" + path.getPathComponent(0));
                    for (int j = 1; j < path.getPathCount(); ++j) {
                        filePath = new File(filePath, "" + path.getPathComponent(j));
                        log.debug("filepath: {}", (Object)filePath);
                    }
                }
                if (filePath != null) {
                    fileName = BaggerFileEntity.normalize((String)filePath.getPath());
                }
                log.debug("removeData filePath: {}", (Object)fileName);
                if (fileName == null || fileName.isEmpty()) continue;
                try {
                    bag.removeBagFile(fileName);
                    ApplicationContextUtil.addConsoleMessage("Payload data removed: " + fileName);
                    if (node instanceof MutableTreeNode) {
                        model.removeNodeFromParent((MutableTreeNode)node);
                        continue;
                    }
                    DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(node);
                    model.removeNodeFromParent(aNode);
                }
                catch (Exception e) {
                    try {
                        bag.removePayloadDirectory(fileName);
                        if (node instanceof MutableTreeNode) {
                            model.removeNodeFromParent((MutableTreeNode)node);
                            continue;
                        }
                        DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(node);
                        model.removeNodeFromParent(aNode);
                    }
                    catch (Exception ex) {
                        String message = "Error trying to remove: " + fileName + "\n";
                        BagView.showWarningErrorDialog("Error - file not removed", message + ex.getMessage());
                    }
                }
            }
            this.bagView.bagPayloadTree.removeSelectionPaths(paths);
            this.bagView.bagPayloadTreePanel.refresh(this.bagView.bagPayloadTree);
        }
    }
}

