/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.common;

import cool.pandora.modeller.templates.CollectionScope;
import cool.pandora.modeller.templates.ListScope;
import cool.pandora.modeller.templates.MetadataTemplate;
import cool.pandora.modeller.templates.Scope;
import cool.pandora.modeller.util.ResourceCollectionWriter;
import cool.pandora.modeller.util.ServiceNodeWriter;
import cool.pandora.modeller.util.TextCollectionWriter;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class TextSequenceMetadata {
    private TextSequenceMetadata() {
    }

    public static InputStream getTextSequenceMetadata(Map<String, List<String>> resourceIDList, String pageId, String canvasRegionURI, String collectionPredicate, URI resourceContainerIRI) {
        ArrayList idList = new ArrayList(resourceIDList.get(pageId));
        TextCollectionWriter collectionWriter = TextCollectionWriter.collection().idList(idList).collectionPredicate(collectionPredicate).resourceContainerIRI(resourceContainerIRI.toString()).canvasURI(canvasRegionURI).build();
        String collection = collectionWriter.render();
        List<CollectionScope.Prefix> prefixes = Arrays.asList(new CollectionScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new CollectionScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"));
        CollectionScope scope = new CollectionScope().fedoraPrefixes(prefixes).sequenceGraph(collection);
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-seq.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = StringEscapeUtils.unescapeXml((String)metadataTemplate.render());
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }

    public static InputStream getListSequenceMetadata(Map<String, List<String>> resourceIDList, String listURI, Map<String, String> resourceTargetMap, String collectionPredicate, String listServiceBaseURI) {
        ArrayList idList = new ArrayList(resourceIDList.get(listURI));
        ResourceCollectionWriter collectionWriter = ResourceCollectionWriter.collection().idList(idList).collectionPredicate(collectionPredicate).resourceTargetMap(resourceTargetMap).build();
        String collection = collectionWriter.render();
        String serviceURI = listServiceBaseURI + listURI;
        ServiceNodeWriter serviceNodeWriter = ServiceNodeWriter.init().serviceURI(serviceURI).servicePredicate("http://rdfs.org/sioc/services#has_service").serviceType("http://localhost:3000/listcontext.json").build();
        String serviceNode = serviceNodeWriter.render();
        List<ListScope.Prefix> prefixes = Arrays.asList(new ListScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new ListScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"), new ListScope.Prefix("PREFIX svcs: <http://rdfs.org/sioc/services#>"), new ListScope.Prefix("PREFIX sc: <http://iiif.io/api/presentation/2#>"));
        ListScope scope = new ListScope().fedoraPrefixes(prefixes).sequenceGraph(collection).serviceNode(serviceNode);
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-list.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = StringEscapeUtils.unescapeXml((String)metadataTemplate.render());
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }
}

