/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.base.SaveBagHandler;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.CreateDefaultContainersFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDefaultContainersHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(SaveBagHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateDefaultContainersHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.containercreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI collectionIDURI = IIIFObjectURI.getCollectionIdURI(map);
        URI objektURI = IIIFObjectURI.getObjektURI(map);
        try {
            ModellerClient.doPut((URI)collectionIDURI);
        }
        catch (ModellerClientFailedException e) {
            ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
        }
        try {
            ModellerClient.doPut((URI)objektURI);
        }
        catch (ModellerClientFailedException e) {
            ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
        }
        String[] IIIFContainers = new String[]{"IIIFResourceContainer", "IIIFManifestResourceLabel", "IIIFSequenceContainer", "IIIFRangeContainer", "IIIFCanvasContainer", "IIIFListContainer", "IIIFLayerContainer"};
        String[] TextContainers = new String[]{"TextPageContainer", "TextAreaContainer", "TextLineContainer", "TextWordContainer"};
        String[] Containers = bag.hasText() ? (String[])Stream.concat(Arrays.stream(IIIFContainers), Arrays.stream(TextContainers)).toArray(String[]::new) : IIIFContainers;
        for (String containerKey : Containers) {
            URI containerURI = IIIFObjectURI.buildContainerURI(map, containerKey);
            try {
                ModellerClient.doPut((URI)containerURI);
                ApplicationContextUtil.addConsoleMessage(message + " " + containerURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openCreateDefaultContainersFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateDefaultContainersFrame createDefaultContainersFrame = new CreateDefaultContainersFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.put"));
        createDefaultContainersFrame.setBag(bag);
        createDefaultContainersFrame.setVisible(true);
    }
}

