/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.base.SaveBagHandler;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.CreateSequencesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.HashMap;
import javax.swing.AbstractAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSequencesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(SaveBagHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateSequencesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreateSequencesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.sequencecreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        String sequenceID = bag.getSequenceID();
        URI sequenceObjectURI = IIIFObjectURI.getSequenceObjectURI(map, sequenceID);
        try {
            ModellerClient.doPut((URI)sequenceObjectURI);
            ApplicationContextUtil.addConsoleMessage(message + " " + sequenceObjectURI);
        }
        catch (ModellerClientFailedException e) {
            ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
        }
        this.bagView.getControl().invalidate();
    }

    void openCreateSequencesFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateSequencesFrame createSequencesFrame = new CreateSequencesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.sequence"));
        createSequencesFrame.setBag(bag);
        createSequencesFrame.setVisible(true);
    }
}

