/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.iiif;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.templates.ManifestScope;
import cool.pandora.modeller.templates.MetadataTemplate;
import cool.pandora.modeller.templates.Scope;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.iiif.PatchManifestFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchManifestHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchManifestHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchManifestHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.manifestpatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI collectionIdURI = IIIFObjectURI.getCollectionIdURI(map);
        URI sequenceIdURI = IIIFObjectURI.getSequenceObjectURI(map, "normal");
        InputStream rdfBody = PatchManifestHandler.getManifestMetadata(collectionIdURI, sequenceIdURI, map);
        URI destinationURI = IIIFObjectURI.getManifestResource(map);
        try {
            ModellerClient.doPatch((URI)destinationURI, (InputStream)rdfBody);
            ApplicationContextUtil.addConsoleMessage(message + " " + destinationURI);
        }
        catch (ModellerClientFailedException e) {
            ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchManifestFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchManifestFrame patchManifestFrame = new PatchManifestFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.manifest"));
        patchManifestFrame.setBag(bag);
        patchManifestFrame.setVisible(true);
    }

    private static InputStream getManifestMetadata(URI collectionIdURI, URI sequenceIdURI, Map<String, BagInfoField> map) {
        List<ManifestScope.Prefix> prefixes = Arrays.asList(new ManifestScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new ManifestScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"));
        String label = PatchManifestHandler.getMapValue(map, "Label");
        String attribution = PatchManifestHandler.getMapValue(map, "Attribution");
        String license = PatchManifestHandler.getMapValue(map, "License");
        String rendering = PatchManifestHandler.getMapValue(map, "Rendering URI");
        String logo = PatchManifestHandler.getMapValue(map, "Logo URI");
        String author = PatchManifestHandler.getMapValue(map, "Author");
        String published = PatchManifestHandler.getMapValue(map, "Published");
        ManifestScope scope = new ManifestScope().fedoraPrefixes(prefixes).collectionURI(collectionIdURI.toString()).sequenceURI(sequenceIdURI.toString()).label(label).attribution(attribution).license(license).logo(logo).rendering(rendering).author(author).published(published);
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-manifest.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = StringEscapeUtils.unescapeXml((String)metadataTemplate.render());
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }

    private static String getMapValue(Map<String, BagInfoField> map, String key) {
        BagInfoField bagDescriptorKey = map.get(key);
        return bagDescriptorKey != null ? bagDescriptorKey.getValue() : null;
    }
}

