/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.CreateAreasFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateAreasHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(CreateAreasHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateAreasHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreateAreasFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.areacreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        String url = bag.gethOCRResource();
        List areaIdList = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            areaIdList = DocManifestBuilder.getAreaIdList((hOCRData)hocr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (areaIdList != null);
        for (String resourceID : areaIdList) {
            resourceID = StringUtils.substringAfter((String)resourceID, (String)"_");
            URI areaObjectURI = TextObjectURI.getAreaObjectURI(map, resourceID);
            try {
                ModellerClient.doPut((URI)areaObjectURI);
                ApplicationContextUtil.addConsoleMessage(message + " " + areaObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openCreateAreasFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateAreasFrame createAreasFrame = new CreateAreasFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.areas"));
        createAreasFrame.setBag(bag);
        createAreasFrame.setVisible(true);
    }
}

