/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.CreateLinesFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLinesHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(CreateLinesHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public CreateLinesHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openCreateLinesFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.linecreated");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        String url = bag.gethOCRResource();
        List lineIdList = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            lineIdList = DocManifestBuilder.getLineIdList((hOCRData)hocr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (lineIdList != null);
        for (String resourceID : lineIdList) {
            resourceID = StringUtils.substringAfter((String)resourceID, (String)"_");
            URI lineObjectURI = TextObjectURI.getLineObjectURI(map, resourceID);
            try {
                ModellerClient.doPut((URI)lineObjectURI);
                ApplicationContextUtil.addConsoleMessage(message + " " + lineObjectURI);
            }
            catch (ModellerClientFailedException e) {
                ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openCreateLinesFrame() {
        DefaultBag bag = this.bagView.getBag();
        CreateLinesFrame createLinesFrame = new CreateLinesFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.lines"));
        createLinesFrame.setBag(bag);
        createLinesFrame.setVisible(true);
    }
}

