/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.handlers.text;

import cool.pandora.modeller.CanvasRegionURI;
import cool.pandora.modeller.DocManifestBuilder;
import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import cool.pandora.modeller.Region;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.templates.MetadataTemplate;
import cool.pandora.modeller.templates.Scope;
import cool.pandora.modeller.templates.WordScope;
import cool.pandora.modeller.ui.Progress;
import cool.pandora.modeller.ui.handlers.common.IIIFObjectURI;
import cool.pandora.modeller.ui.handlers.common.NodeMap;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.jpanel.text.PatchWordsFrame;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchWordsHandler
extends AbstractAction
implements Progress {
    protected static final Logger log = LoggerFactory.getLogger(PatchWordsHandler.class);
    private static final long serialVersionUID = 1L;
    private final BagView bagView;

    public PatchWordsHandler(BagView bagView) {
        this.bagView = bagView;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.openPatchWordsFrame();
    }

    @Override
    public void execute() {
        String message = ApplicationContextUtil.getMessage("bag.message.wordpatched");
        DefaultBag bag = this.bagView.getBag();
        HashMap map = bag.getInfo().getFieldMap();
        URI canvasContainerURI = IIIFObjectURI.getCanvasContainerURI(map);
        URI wordContainerURI = TextObjectURI.getWordContainerURI(map);
        String url = bag.gethOCRResource();
        List pageIdList = null;
        List wordIdList = null;
        Map<String, String> bboxmap = null;
        Map<String, String> charmap = null;
        try {
            hOCRData hocr = DocManifestBuilder.gethOCRProjectionFromURL((String)url);
            pageIdList = DocManifestBuilder.getPageIdList((hOCRData)hocr);
            wordIdList = DocManifestBuilder.getWordIdList((hOCRData)hocr);
            bboxmap = NodeMap.getBBoxWordMap(hocr, wordIdList);
            charmap = NodeMap.getCharWordMap(hocr, wordIdList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Map<String, String> canvasPageMap = NodeMap.getCanvasPageMap(pageIdList, canvasContainerURI);
        if (wordIdList != null) {
            for (String wordId : wordIdList) {
                String subWordId = StringUtils.substringAfter((String)wordId, (String)"_");
                URI wordObjectURI = TextObjectURI.getWordObjectURI(map, subWordId);
                String canvasURI = null;
                if (canvasPageMap != null) {
                    canvasURI = canvasPageMap.get(StringUtils.substringBefore((String)subWordId, (String)"_"));
                }
                String bbox = bboxmap.get(wordId);
                String chars = charmap.get(wordId);
                String region = Region.region().bbox(bbox).build();
                String canvasRegionURI = CanvasRegionURI.regionuri().region(region).canvasURI(canvasURI).build();
                if (!(canvasRegionURI != null & chars != null & wordContainerURI != null)) continue;
                InputStream rdfBody = PatchWordsHandler.getWordMetadata(canvasRegionURI, wordContainerURI.toString(), chars);
                try {
                    ModellerClient.doPatch((URI)wordObjectURI, (InputStream)rdfBody);
                    ApplicationContextUtil.addConsoleMessage(message + " " + wordObjectURI);
                }
                catch (ModellerClientFailedException e) {
                    ApplicationContextUtil.addConsoleMessage(ExceptionUtils.getMessage((Throwable)e));
                }
            }
        }
        this.bagView.getControl().invalidate();
    }

    void openPatchWordsFrame() {
        DefaultBag bag = this.bagView.getBag();
        PatchWordsFrame patchWordsFrame = new PatchWordsFrame(this.bagView, this.bagView.getPropertyMessage("bag.frame.patch.words"));
        patchWordsFrame.setBag(bag);
        patchWordsFrame.setVisible(true);
    }

    private static InputStream getWordMetadata(String canvasRegionURI, String wordContainerURI, String chars) {
        List<WordScope.Prefix> prefixes = Arrays.asList(new WordScope.Prefix("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"), new WordScope.Prefix("PREFIX mode: <http://www.modeshape.org/1.0>"), new WordScope.Prefix("PREFIX oa: <http://www.w3.org/ns/oa#>"), new WordScope.Prefix("PREFIX cnt: <http://www.w3.org/2011/content#>"), new WordScope.Prefix("PREFIX sc: <http://iiif.io/api/presentation/2#>"), new WordScope.Prefix("PREFIX dctypes: <http://purl.org/dc/dcmitype/>"));
        WordScope scope = new WordScope().fedoraPrefixes(prefixes).canvasURI(canvasRegionURI).resourceContainerURI(wordContainerURI).chars(chars.replace("\"", "\\\""));
        MetadataTemplate metadataTemplate = MetadataTemplate.template().template("template/sparql-update-word.mustache").scope((Scope)scope).throwExceptionOnFailure().build();
        String metadata = StringEscapeUtils.unescapeXml((String)metadataTemplate.render());
        return IOUtils.toInputStream((String)metadata, (Charset)StandardCharsets.UTF_8);
    }
}

