/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.impl.DefaultBagInfo;
import cool.pandora.modeller.bag.impl.ManifestPropertiesImpl;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.LayoutUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddFieldPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(AddFieldPanel.class);
    private final JCheckBox standardCheckBox;
    private final JComboBox<String> standardFieldsComboBox;
    private final JTextField customFieldTextField;
    private final JTextField valueField;

    AddFieldPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        boolean row = false;
        int col = 0;
        this.standardCheckBox = new JCheckBox("Standard");
        this.standardCheckBox.setSelected(true);
        this.standardCheckBox.addActionListener(new StandardFieldCheckBoxAction());
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        this.add((Component)this.standardCheckBox, gbc);
        List<String> listModel = AddFieldPanel.getStandardBagFields();
        this.standardFieldsComboBox = new JComboBox<String>(listModel.toArray(new String[listModel.size()]));
        this.standardFieldsComboBox.setName(ApplicationContextUtil.getMessage("baginfo.field.fieldlist"));
        this.standardFieldsComboBox.setSelectedItem("");
        this.standardFieldsComboBox.setToolTipText(ApplicationContextUtil.getMessage("baginfo.field.fieldlist.help"));
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        this.add(this.standardFieldsComboBox, gbc);
        this.customFieldTextField = new JTextField(17);
        this.customFieldTextField.setToolTipText(ApplicationContextUtil.getMessage("baginfo.field.name.help"));
        this.customFieldTextField.setVisible(false);
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        this.add((Component)this.customFieldTextField, gbc);
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        this.add((Component)new JLabel(" : "), gbc);
        this.valueField = new JTextField();
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 1, 1, 2, 17);
        this.add((Component)this.valueField, gbc);
        JButton addFieldButton = new JButton("Add");
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        this.add((Component)addFieldButton, gbc);
        addFieldButton.addActionListener(new AddFieldAction());
    }

    private static List<String> getStandardBagFields() {
        Field[] fields;
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        for (Field field : fields = ManifestPropertiesImpl.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("FIELD_")) continue;
            String standardFieldName = null;
            try {
                standardFieldName = (String)field.get(ManifestPropertiesImpl.class);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (DefaultBagInfo.isOrganizationContactField((String)field.getName()) || DefaultBagInfo.isManifestPropertyField((String)field.getName()) || standardFieldName.compareTo("Bag-Size") == 0 || standardFieldName.compareTo("Payload-Oxum") == 0) continue;
            log.debug("adding standard field: {}", (Object)standardFieldName);
            list.add(standardFieldName);
        }
        return list;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            component.setEnabled(enabled);
        }
    }

    private BagInfoField createBagInfoField() {
        BagView bagView = ApplicationContextUtil.getBagView();
        BagInfoField field = new BagInfoField();
        String fieldName = this.isStandardField() ? (String)this.standardFieldsComboBox.getSelectedItem() : this.customFieldTextField.getText();
        if (fieldName.trim().isEmpty()) {
            BagView.showWarningErrorDialog("New Field Dialog", "Field name must be specified!");
            return null;
        }
        field.setName(fieldName);
        field.setLabel(fieldName);
        field.setValue(this.valueField.getText().trim());
        field.setComponentType(1);
        return field;
    }

    private boolean isStandardField() {
        return this.standardCheckBox.isSelected();
    }

    private class AddFieldAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private AddFieldAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BagView bagView = ApplicationContextUtil.getBagView();
            BagInfoField field = AddFieldPanel.this.createBagInfoField();
            if (field != null) {
                bagView.getBag().addField(field);
                bagView.infoInputPane.updateInfoFormsPane();
                bagView.infoInputPane.bagInfoInputPane.requestFocus();
            }
        }
    }

    private class StandardFieldCheckBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private StandardFieldCheckBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBox checkbox = (JCheckBox)e.getSource();
            boolean standardFieldSelected = checkbox.isSelected();
            if (standardFieldSelected) {
                AddFieldPanel.this.standardFieldsComboBox.setVisible(true);
                AddFieldPanel.this.standardFieldsComboBox.requestFocus();
                AddFieldPanel.this.customFieldTextField.setVisible(false);
            } else {
                AddFieldPanel.this.standardFieldsComboBox.setVisible(false);
                AddFieldPanel.this.customFieldTextField.setVisible(true);
                AddFieldPanel.this.customFieldTextField.requestFocus();
            }
        }
    }
}

