/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.BagTableFormBuilder;
import cool.pandora.modeller.ui.NoTabTextArea;
import cool.pandora.modeller.ui.jpanel.base.AddFieldPanel;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.LayoutUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.AbstractForm;

public class BagInfoForm
extends AbstractForm
implements FocusListener {
    protected static final Logger log = LoggerFactory.getLogger(BagInfoForm.class);
    private static final String INFO_FORM_PAGE = "infoPage";
    private JComponent focusField;
    private BagView bagView;
    private final HashMap<String, BagInfoField> fieldMap;
    private JComponent form;
    private AddFieldPanel addFieldPannel;

    public BagInfoForm(FormModel formModel, BagView bagView, HashMap<String, BagInfoField> map) {
        super(formModel, INFO_FORM_PAGE);
        this.bagView = bagView;
        this.fieldMap = map;
    }

    public void setBagView(BagView bagView) {
        this.bagView = bagView;
    }

    protected JComponent createFormControl() {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        int row = 0;
        boolean col = false;
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(0, row++, 1, 1, 0, 0, 2, 17);
        this.addFieldPannel = new AddFieldPanel();
        contentPanel.add((Component)this.addFieldPannel, gbc);
        gbc = LayoutUtil.buildGridBagConstraints(0, row++, 1, 1, 0, 0, 2, 10);
        contentPanel.add((Component)new JSeparator(), gbc);
        this.form = this.createFormFields();
        gbc = LayoutUtil.buildGridBagConstraints(0, row++, 1, 1, 1, 1, 1, 17);
        contentPanel.add((Component)this.form, gbc);
        return contentPanel;
    }

    private JComponent createFormFields() {
        BagTableFormBuilder formBuilder = new BagTableFormBuilder(this.getBindingFactory());
        formBuilder.row();
        if (this.fieldMap != null && !this.fieldMap.isEmpty()) {
            this.createFormFieldsFromMap(formBuilder);
        }
        JComponent fieldForm = formBuilder.getForm();
        fieldForm.invalidate();
        return fieldForm;
    }

    private void createFormFieldsFromMap(BagTableFormBuilder formBuilder) {
        int rowCount = 0;
        int index = 2;
        Set<String> keys = this.fieldMap.keySet();
        for (BagInfoField field : this.fieldMap.values()) {
            formBuilder.row();
            ++rowCount;
            ImageIcon imageIcon = this.bagView.getPropertyImage("bag.delete.image");
            JButton removeButton = new JButton(imageIcon);
            Dimension dimension = removeButton.getPreferredSize();
            dimension.width = imageIcon.getIconWidth();
            removeButton.setMaximumSize(dimension);
            removeButton.setOpaque(false);
            removeButton.setBorderPainted(false);
            removeButton.setContentAreaFilled(false);
            removeButton.addActionListener(new RemoveFieldHandler());
            this.logger.debug((Object)("OrganizationInfoForm add: " + field));
            if (field.getValue() != null && field.getValue().length() > 60) {
                field.setComponentType(2);
            }
            if (field.isRequired()) {
                removeButton = new JButton();
                removeButton.setOpaque(false);
                removeButton.setBorderPainted(false);
                removeButton.setContentAreaFilled(false);
            }
            switch (field.getComponentType()) {
                case 2: {
                    JComponent[] tlist = formBuilder.addTextArea(field.isRequired(), field.getLabel(), removeButton);
                    JComponent textarea = tlist[2];
                    textarea.setEnabled(field.isEnabled());
                    textarea.addFocusListener(this);
                    ((NoTabTextArea)textarea).setText(field.getValue());
                    textarea.setBorder(new EmptyBorder(1, 1, 1, 1));
                    ((NoTabTextArea)textarea).setLineWrap(true);
                    if (rowCount != 1) break;
                    this.focusField = textarea;
                    break;
                }
                case 1: {
                    JComponent[] flist = formBuilder.add(field.isRequired(), field.getLabel(), removeButton);
                    JComponent comp = flist[2];
                    comp.setEnabled(field.isEnabled());
                    comp.addFocusListener(this);
                    ((JTextField)comp).setText(field.getValue());
                    if (rowCount != 1) break;
                    this.focusField = comp;
                    break;
                }
                case 3: {
                    List elements = field.getElements();
                    JComponent[] llist = formBuilder.addList(field.isRequired(), field.getLabel(), elements, field.getValue(), removeButton);
                    JComponent lcomp = llist[2];
                    lcomp.setEnabled(field.isEnabled());
                    lcomp.addFocusListener(this);
                    if (field.getValue() != null) {
                        ((JComboBox)lcomp).setSelectedItem(field.getValue().trim());
                    }
                    if (rowCount != 1) break;
                    this.focusField = lcomp;
                    break;
                }
            }
        }
        if (this.focusField != null) {
            this.focusField.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
        DefaultBag defaultBag = this.bagView.getBag();
        this.bagView.infoInputPane.updateBagHandler.updateBag(defaultBag);
        this.bagView.infoInputPane.bagInfoInputPane.setSelectedIndex(0);
    }

    private BagInfoField getField(String key) {
        Set<String> keys = this.fieldMap.keySet();
        for (String keySet : keys) {
            if (!keySet.equalsIgnoreCase(key)) continue;
            BagInfoField field = this.fieldMap.get(key);
            return field;
        }
        return null;
    }

    public HashMap<String, String> getBagInfoMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String key = "";
        String value = "";
        Component[] components = this.getFieldComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                key = label.getText();
            }
            c = components[++i];
            if ((c = components[++i]) instanceof JTextField) {
                JTextField tf = (JTextField)c;
                value = tf.getText();
            } else if (c instanceof JTextArea) {
                JTextArea ta = (JTextArea)c;
                value = ta.getText();
            } else if (c instanceof JComboBox) {
                JComboBox tb = (JComboBox)c;
                value = (String)tb.getSelectedItem();
            }
            map.put(key, value);
            c = components[++i];
        }
        return map;
    }

    private Component[] getFieldComponents() {
        return this.form.getComponents();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addFieldPannel.setEnabled(enabled);
    }

    private class RemoveFieldHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private RemoveFieldHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component selected = (Component)e.getSource();
            String key = "";
            Component[] components = BagInfoForm.this.getFieldComponents();
            for (int i = 0; i < components.length; ++i) {
                BagInfoField field;
                Component c = components[i];
                if (c instanceof JLabel) {
                    JLabel label = (JLabel)c;
                    key = label.getText();
                }
                c = components[++i];
                c = components[++i];
                if (!((c = components[++i]) instanceof JButton) || c != selected || (field = BagInfoForm.this.getField(key)) == null) continue;
                BagInfoForm.this.bagView.getBag().removeBagInfoField(key);
            }
            ((BagInfoForm)BagInfoForm.this).bagView.infoInputPane.updateInfoFormsPane();
        }
    }
}

