/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.model.BagStatus;
import cool.pandora.modeller.ui.StatusImageLabel;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.LayoutUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsolePane
extends JPanel {
    private static final int MAX_CONSOLE_MESSAGE_LENGTH = 50000;
    private static final long serialVersionUID = -4290352509246639528L;
    protected static final Logger log = LoggerFactory.getLogger(ConsolePane.class);
    public static final String CONSOLE_PANE = "consolePane";
    private final Dimension maxDimension = new Dimension(400, 300);
    private final Dimension preferredDimension = new Dimension(400, 150);
    private final Color textBackground = new Color(240, 240, 240);
    private final Border emptyBorder = new EmptyBorder(10, 10, 10, 10);
    private JTextArea serializedArea;

    public ConsolePane(String messages) {
        this.setLayout(new GridBagLayout());
        this.createFormControl();
        this.addConsoleMessages(messages);
    }

    private void createFormControl() {
        this.setMaximumSize(this.maxDimension);
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(0, 0, 1, 1, 0, 0, 2, 17);
        this.add((Component)ConsolePane.createStatusPannel(), gbc);
        gbc = LayoutUtil.buildGridBagConstraints(0, 1, 1, 1, 1, 1, 1, 10);
        this.add((Component)this.createConsoleArea(), gbc);
        this.setBorder(this.emptyBorder);
        this.setPreferredSize(this.preferredDimension);
    }

    private static JPanel createStatusPannel() {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new GridBagLayout());
        boolean row = false;
        int col = 0;
        BagStatus bagStatus = BagStatus.getInstance();
        JLabel completeLabel = new JLabel(ApplicationContextUtil.getMessage("compositePane.message.isComplete") + " ");
        completeLabel.setToolTipText(ApplicationContextUtil.getMessage("consolepane.iscomplete.help"));
        GridBagConstraints gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        statusPanel.add((Component)completeLabel, gbc);
        StatusImageLabel completeStatus = new StatusImageLabel(bagStatus.getCompletenessStatus());
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 1, 1, 2, 17);
        statusPanel.add((Component)completeStatus, gbc);
        JLabel validationLabel = new JLabel(ApplicationContextUtil.getMessage("compositePane.message.isValid") + " ");
        validationLabel.setToolTipText(ApplicationContextUtil.getMessage("consolepane.isvalid.help"));
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        statusPanel.add((Component)validationLabel, gbc);
        StatusImageLabel validationStatus = new StatusImageLabel(bagStatus.getValidationStatus());
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 1, 1, 2, 17);
        statusPanel.add((Component)validationStatus, gbc);
        JLabel profileComplianceLabel = new JLabel(ApplicationContextUtil.getMessage("compositePane.message.isMetadata") + " ");
        profileComplianceLabel.setToolTipText(ApplicationContextUtil.getMessage("consolepane.ismetadata.help"));
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 0, 0, 0, 17);
        statusPanel.add((Component)profileComplianceLabel, gbc);
        StatusImageLabel profileComplianceStatus = new StatusImageLabel(bagStatus.getProfileComplianceStatus());
        gbc = LayoutUtil.buildGridBagConstraints(col++, 0, 1, 1, 1, 1, 2, 17);
        statusPanel.add((Component)profileComplianceStatus, gbc);
        return statusPanel;
    }

    private JScrollPane createConsoleArea() {
        this.serializedArea = new JTextArea();
        this.serializedArea.setToolTipText(ApplicationContextUtil.getMessage("consolepane.msg.help"));
        this.serializedArea.setEditable(false);
        this.serializedArea.setLineWrap(true);
        this.serializedArea.setBackground(this.textBackground);
        this.serializedArea.setWrapStyleWord(true);
        this.serializedArea.setAutoscrolls(true);
        this.serializedArea.setBorder(BorderFactory.createLineBorder(Color.black));
        return new JScrollPane(this.serializedArea);
    }

    public void addConsoleMessages(String message) {
        if (message != null && message.trim().length() != 0) {
            Document consoleMessageDoc = this.serializedArea.getDocument();
            String date = new Date().toString();
            this.serializedArea.append("\n[" + date + "]: " + message);
            if (consoleMessageDoc.getLength() > 50000) {
                try {
                    consoleMessageDoc.remove(0, consoleMessageDoc.getLength() - 50000);
                }
                catch (BadLocationException e) {
                    log.error("Could not remove message from console", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            this.serializedArea.setAutoscrolls(true);
            this.serializedArea.setCaretPosition(consoleMessageDoc.getLength());
        }
    }

    public void clearConsoleMessages() {
        this.serializedArea.setText("");
    }
}

