/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.base;

import cool.pandora.modeller.ui.jpanel.base.BagView;
import cool.pandora.modeller.ui.util.ApplicationContextUtil;
import cool.pandora.modeller.ui.util.LayoutUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationPage;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.util.GuiStandardUtils;

public class NewBagFrame
extends JFrame
implements ActionListener {
    protected static final Logger log = LoggerFactory.getLogger(NewBagFrame.class);
    private static final long serialVersionUID = 1L;
    private final transient BagView bagView;
    private JComboBox<String> profileList;
    protected static final String DEFAULT_FINISH_COMMAND_ID = "okCommand";
    protected static final String DEFAULT_CANCEL_COMMAND_ID = "cancelCommand";
    private transient ActionCommand finishCommand;
    private transient ActionCommand cancelCommand;

    public NewBagFrame(BagView bagView, String title) {
        super(title);
        JPanel createPanel;
        Application app = Application.instance();
        ApplicationPage page = app.getActiveWindow().getPage();
        PageComponent component = page.getActiveComponent();
        this.bagView = component != null ? ApplicationContextUtil.getBagView() : bagView;
        if (bagView != null) {
            this.getContentPane().removeAll();
            createPanel = this.createComponents();
        } else {
            createPanel = new JPanel();
        }
        this.getContentPane().add((Component)createPanel, "Center");
        this.setPreferredSize(new Dimension(400, 200));
        this.setLocation(300, 200);
        this.pack();
    }

    private JPanel createComponents() {
        TitlePane titlePane = new TitlePane();
        this.initStandardCommands();
        JPanel pageControl = new JPanel(new BorderLayout());
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePane.setTitle(this.bagView.getPropertyMessage("NewBagFrame.title"));
        titlePane.setMessage((Message)new DefaultMessage(this.bagView.getPropertyMessage("NewBagFrame.description")));
        titlePaneContainer.add(titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        pageControl.add((Component)titlePaneContainer, "North");
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        int row = 0;
        NewBagFrame.layoutBagVersionSelection(contentPane, row++);
        this.layoutProfileSelection(contentPane, row++);
        if (this.getPreferredSize() != null) {
            contentPane.setPreferredSize(this.getPreferredSize());
        }
        GuiStandardUtils.attachDialogBorder((JComponent)contentPane);
        pageControl.add(contentPane);
        JComponent buttonBar = this.createButtonBar();
        pageControl.add((Component)buttonBar, "South");
        this.pack();
        return pageControl;
    }

    private static void layoutBagVersionSelection(JPanel contentPane, int row) {
        JLabel spacerLabel = new JLabel();
        GridBagConstraints glbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 5, 50, 2, 17);
        glbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 40, 50, 2, 10);
        glbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 40, 50, 0, 13);
        contentPane.add((Component)spacerLabel, glbc);
    }

    private void layoutProfileSelection(JPanel contentPane, int row) {
        JLabel bagProfileLabel = new JLabel(this.bagView.getPropertyMessage("Select Profile:"));
        bagProfileLabel.setToolTipText(this.bagView.getPropertyMessage("bag.projectlist.help"));
        this.profileList = new JComboBox<String>(this.bagView.getProfileStore().getProfileNames());
        this.profileList.setName(this.bagView.getPropertyMessage("bag.label.projectlist"));
        this.profileList.setSelectedItem(this.bagView.getPropertyMessage("bag.project.noproject"));
        this.profileList.setToolTipText(this.bagView.getPropertyMessage("bag.projectlist.help"));
        GridBagConstraints glbc = new GridBagConstraints();
        JLabel spacerLabel = new JLabel();
        glbc = LayoutUtil.buildGridBagConstraints(0, row, 1, 1, 5, 50, 2, 17);
        contentPane.add((Component)bagProfileLabel, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(1, row, 1, 1, 40, 50, 2, 10);
        contentPane.add(this.profileList, glbc);
        glbc = LayoutUtil.buildGridBagConstraints(2, row, 1, 1, 40, 50, 0, 13);
        contentPane.add((Component)spacerLabel, glbc);
    }

    protected JComponent createButtonBar() {
        CommandGroup dialogCommandGroup = CommandGroup.createCommandGroup(null, (Object[])this.getCommandGroupMembers());
        JComponent buttonBar = dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    protected Object[] getCommandGroupMembers() {
        return new AbstractCommand[]{this.finishCommand, this.cancelCommand};
    }

    private void initStandardCommands() {
        this.finishCommand = new ActionCommand(NewBagFrame.getFinishCommandId()){

            public void doExecuteCommand() {
                log.info("BagVersionFrame.OkNewBagHandler");
                NewBagFrame.this.hideNewBagFrame();
                ((NewBagFrame)NewBagFrame.this).bagView.startNewBagHandler.createNewBag((String)NewBagFrame.this.profileList.getSelectedItem());
            }
        };
        this.cancelCommand = new ActionCommand(NewBagFrame.getCancelCommandId()){

            public void doExecuteCommand() {
                NewBagFrame.this.hideNewBagFrame();
            }
        };
    }

    private void hideNewBagFrame() {
        this.setVisible(false);
    }

    protected static String getFinishCommandId() {
        return DEFAULT_FINISH_COMMAND_ID;
    }

    protected static String getCancelCommandId() {
        return DEFAULT_CANCEL_COMMAND_ID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.invalidate();
        this.repaint();
    }
}

