/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.ui.jpanel.text;

import cool.pandora.modeller.bag.BagInfoField;
import cool.pandora.modeller.bag.impl.DefaultBag;
import cool.pandora.modeller.ui.handlers.common.TextObjectURI;
import cool.pandora.modeller.ui.jpanel.base.BagView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.util.GuiStandardUtils;

public class CreateAreasFrame
extends JFrame
implements ActionListener {
    protected static final Logger log = LoggerFactory.getLogger(CreateAreasFrame.class);
    private static final long serialVersionUID = 1L;
    private final transient BagView bagView;
    private Map<String, BagInfoField> map;
    private final JPanel savePanel;
    private JTextField hocrResourceField;
    protected static final String DEFAULT_FINISH_COMMAND_ID = "okCommand";
    protected static final String DEFAULT_CANCEL_COMMAND_ID = "cancelCommand";
    private transient ActionCommand finishCommand;
    private transient ActionCommand cancelCommand;

    public CreateAreasFrame(BagView bagView, String title) {
        super(title);
        this.bagView = bagView;
        if (bagView != null) {
            this.getContentPane().removeAll();
            this.savePanel = this.createComponents();
        } else {
            this.savePanel = new JPanel();
        }
        this.getContentPane().add((Component)this.savePanel, "Center");
        Dimension preferredDimension = new Dimension(600, 400);
        this.setPreferredSize(preferredDimension);
        this.setBounds(300, 200, 600, 400);
        this.pack();
    }

    private JComponent createButtonBar() {
        CommandGroup dialogCommandGroup = CommandGroup.createCommandGroup(null, (Object[])this.getCommandGroupMembers());
        JComponent buttonBar = dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    private Object[] getCommandGroupMembers() {
        return new AbstractCommand[]{this.finishCommand, this.cancelCommand};
    }

    private void initStandardCommands() {
        this.finishCommand = new ActionCommand(CreateAreasFrame.getFinishCommandId()){

            public void doExecuteCommand() {
                new OkCreateAreasHandler().actionPerformed(null);
            }
        };
        this.cancelCommand = new ActionCommand(CreateAreasFrame.getCancelCommandId()){

            public void doExecuteCommand() {
                new CancelCreateAreasHandler().actionPerformed(null);
            }
        };
    }

    private static String getFinishCommandId() {
        return DEFAULT_FINISH_COMMAND_ID;
    }

    private static String getCancelCommandId() {
        return DEFAULT_CANCEL_COMMAND_ID;
    }

    private JPanel createComponents() {
        EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
        TitlePane titlePane = new TitlePane();
        this.initStandardCommands();
        JPanel pageControl = new JPanel(new BorderLayout());
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePane.setTitle(this.bagView.getPropertyMessage("CreateAreasFrame.title"));
        titlePane.setMessage((Message)new DefaultMessage(this.bagView.getPropertyMessage("Create Areas in:")));
        titlePaneContainer.add(titlePane.getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        pageControl.add((Component)titlePaneContainer, "North");
        JPanel contentPane = new JPanel();
        DefaultBag bag = this.bagView.getBag();
        if (bag != null) {
            this.map = bag.getInfo().getFieldMap();
        }
        JLabel urlLabel = new JLabel(this.bagView.getPropertyMessage("baseURL.label"));
        urlLabel.setToolTipText(this.bagView.getPropertyMessage("baseURL.description"));
        JTextField urlField = new JTextField("");
        URI uri = TextObjectURI.getAreaContainerURI(this.map);
        try {
            urlField.setText(uri != null ? uri.toString() : null);
        }
        catch (Exception e) {
            log.error("Failed to set url label", (Throwable)e);
        }
        JLabel hocrResourceLabel = new JLabel(this.bagView.getPropertyMessage("hocrResource.label"));
        hocrResourceLabel.setToolTipText(this.bagView.getPropertyMessage("hocrResource.description"));
        this.hocrResourceField = new JTextField("");
        String hocrResource = TextObjectURI.gethOCRResourceURI(this.map);
        try {
            this.hocrResourceField.setText(hocrResource);
        }
        catch (Exception e) {
            log.error("Failed to set hocrResource label", (Throwable)e);
        }
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints glbc = new GridBagConstraints();
        JPanel panel = new JPanel(layout);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        int row = 0;
        CreateAreasFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(urlLabel, glbc);
        panel.add(urlLabel);
        CreateAreasFrame.buildConstraints(glbc, 1, row, 1, 1, 80, 50, 2, 10);
        layout.setConstraints(urlField, glbc);
        panel.add(urlField);
        CreateAreasFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        layout.setConstraints(hocrResourceLabel, glbc);
        panel.add(hocrResourceLabel);
        CreateAreasFrame.buildConstraints(glbc, 1, row, 1, 1, 80, 50, 2, 10);
        layout.setConstraints(this.hocrResourceField, glbc);
        panel.add(this.hocrResourceField);
        CreateAreasFrame.buildConstraints(glbc, 0, ++row, 1, 1, 1, 50, 0, 17);
        CreateAreasFrame.buildConstraints(glbc, 1, row, 2, 1, 80, 50, 2, 10);
        GuiStandardUtils.attachDialogBorder((JComponent)contentPane);
        pageControl.add(panel);
        JComponent buttonBar = this.createButtonBar();
        pageControl.add((Component)buttonBar, "South");
        this.pack();
        return pageControl;
    }

    public void setBag(DefaultBag bag) {
        this.savePanel.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.invalidate();
        this.repaint();
    }

    private static void buildConstraints(GridBagConstraints gbc, int x, int y, int w, int h, int wx, int wy, int fill, int anchor) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.anchor = anchor;
    }

    private String getMessage(String property) {
        return this.bagView.getPropertyMessage(property);
    }

    private class CancelCreateAreasHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelCreateAreasHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CreateAreasFrame.this.setVisible(false);
        }
    }

    private class OkCreateAreasHandler
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkCreateAreasHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CreateAreasFrame.this.setVisible(false);
            String hocrFile = CreateAreasFrame.this.hocrResourceField.getText().trim();
            CreateAreasFrame.this.bagView.getBag().sethOCRResource(hocrFile);
            ((CreateAreasFrame)CreateAreasFrame.this).bagView.createAreasHandler.execute();
        }
    }
}

