/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableContainerFactory;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.FloatingDockableContainer;
import com.vlsolutions.swing.docking.SingleDockableContainer;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FloatingDialog
extends JDialog
implements FloatingDockableContainer {
    private static final int DRAG_TOP = 1;
    private static final int DRAG_LEFT = 2;
    private static final int DRAG_RIGHT = 4;
    private static final int DRAG_BOTTOM = 8;
    protected int titleHeight = 6;
    private Color controlColor = UIManager.getColor("control");
    private Color highlight = UIManager.getColor("controlLtHighlight");
    private Color shadow = UIManager.getColor("controlShadow");
    private Color activeCaptionColor = UIManager.getColor("activeCaption");
    private Color inactiveCaptionColor = UIManager.getColor("inactiveCaption");
    private Color activeCaptionBorderColor = UIManager.getColor("activeCaptionBorder");
    private Color inactiveCaptionBorderColor = UIManager.getColor("inactiveCaptionBorder");
    private Border activeBorder = BorderFactory.createLineBorder(this.activeCaptionBorderColor);
    private Border inactiveBorder = BorderFactory.createLineBorder(this.inactiveCaptionBorderColor);
    private JComponent title = this.createTitlePanel();
    private Resizer left = new Resizer();
    private Resizer right = new Resizer();
    private Resizer bottom = new Resizer();
    protected DockingDesktop desktop;

    public FloatingDialog(Dialog parent) {
        super(parent);
        this.init();
    }

    public FloatingDialog(Frame parent) {
        super(parent);
        this.init();
    }

    public void init() {
        this.installDecoration();
        this.installBorders();
        this.installResizers();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                FloatingDialog.this.getRootPane().setBorder(FloatingDialog.this.activeBorder);
                FloatingDialog.this.repaint();
            }

            public void windowDeactivated(WindowEvent e) {
                FloatingDialog.this.getRootPane().setBorder(FloatingDialog.this.inactiveBorder);
                FloatingDialog.this.repaint();
            }
        });
        this.title.setPreferredSize(new Dimension(10, this.titleHeight));
        this.getContentPane().add((Component)this.title, "North");
    }

    public void installDecoration() {
        this.setUndecorated(true);
    }

    public JComponent createTitlePanel() {
        return new TitlePanel();
    }

    public void installBorders() {
        Border border = UIManager.getBorder("FloatingDialog.dialogBorder");
        Border titleBorder = UIManager.getBorder("FloatingDialog.titleBorder");
        this.title.setBorder(titleBorder);
        ((JPanel)this.getContentPane()).setBorder(border);
    }

    public void installResizers() {
        ResizeListener listener = new ResizeListener();
        this.left.addMouseMotionListener(listener);
        this.left.addMouseListener(listener);
        this.right.addMouseMotionListener(listener);
        this.right.addMouseListener(listener);
        this.bottom.addMouseMotionListener(listener);
        this.bottom.addMouseListener(listener);
        this.title.addMouseMotionListener(listener);
        this.title.addMouseListener(listener);
        this.getContentPane().add((Component)this.left, "West");
        this.getContentPane().add((Component)this.right, "East");
        this.getContentPane().add((Component)this.bottom, "South");
        Color inactive = UIManager.getColor("inactiveCaption");
        this.left.setBackground(inactive);
        this.right.setBackground(inactive);
        this.bottom.setBackground(inactive);
    }

    public void installDocking(DockingDesktop desktop) {
        this.desktop = desktop;
    }

    public void setInitialDockable(Dockable dockable) {
        SingleDockableContainer sdc = DockableContainerFactory.getFactory().createDockableContainer(dockable, 3);
        sdc.installDocking(this.desktop);
        Component comp = (Component)((Object)sdc);
        this.getContentPane().add(comp);
    }

    public void setInitialTabbedDockableContainer(TabbedDockableContainer tdc) {
        Component comp = (Component)((Object)tdc);
        this.getContentPane().add(comp);
    }

    protected class Resizer
    extends JComponent {
        Resizer() {
            this.setPreferredSize(new Dimension(3, 3));
            this.setOpaque(true);
        }

        public void paintComponent(Graphics g) {
            if (FloatingDialog.this.isActive()) {
                g.setColor(FloatingDialog.this.activeCaptionColor);
            } else {
                g.setColor(FloatingDialog.this.inactiveCaptionColor);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected class TitlePanel
    extends JComponent {
        protected TitlePanel() {
        }

        public void paintComponent(Graphics g) {
            Color darker;
            if (FloatingDialog.this.isActive()) {
                darker = FloatingDialog.this.activeCaptionColor;
                Color brighter = FloatingDialog.this.activeCaptionBorderColor;
            } else {
                darker = FloatingDialog.this.inactiveCaptionColor;
                Color brighter = FloatingDialog.this.inactiveCaptionBorderColor;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(darker);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            int width = 5;
            int height = 5;
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D ig = image.createGraphics();
            ig.setColor(darker);
            ig.fillRect(0, 0, width, height);
            ig.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
            ig.fillRect(2, 2, 2, 2);
            ig.setColor(new Color(0.0f, 0.0f, 0.0f, 0.2f));
            ig.fillRect(1, 1, 2, 2);
            ig.dispose();
            Rectangle r = new Rectangle(0, 0, width, height);
            TexturePaint tp = null;
            if (tp == null) {
                tp = new TexturePaint(image, r);
            }
            Paint old = g2.getPaint();
            g2.setPaint(tp);
            g2.fillRect(0, 0, this.getWidth(), height);
            g2.setPaint(old);
        }
    }

    private class ResizeListener
    implements MouseMotionListener,
    MouseListener {
        Point lastPoint = null;
        int dragType = -1;

        private ResizeListener() {
        }

        public void mouseDragged(MouseEvent e) {
            Rectangle bounds = FloatingDialog.this.getBounds();
            Dimension d = FloatingDialog.this.getSize();
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, e.getComponent());
            int dx = p.x - this.lastPoint.x;
            int dy = p.y - this.lastPoint.y;
            switch (this.dragType) {
                case 1: {
                    Point loc = FloatingDialog.this.getLocation();
                    FloatingDialog.this.setLocation(loc.x + dx, loc.y + dy);
                    break;
                }
                case 3: {
                    FloatingDialog.this.invalidate();
                    bounds.x += dx;
                    bounds.y += dy;
                    bounds.width -= dx;
                    bounds.height -= dy;
                    FloatingDialog.this.setBounds(bounds);
                    FloatingDialog.this.validate();
                    break;
                }
                case 5: {
                    FloatingDialog.this.invalidate();
                    bounds.y += dy;
                    bounds.width += dx;
                    bounds.height -= dy;
                    FloatingDialog.this.setBounds(bounds);
                    FloatingDialog.this.validate();
                    break;
                }
                case 4: {
                    FloatingDialog.this.invalidate();
                    FloatingDialog.this.setSize(d.width + dx, d.height);
                    FloatingDialog.this.validate();
                    break;
                }
                case 12: {
                    FloatingDialog.this.invalidate();
                    FloatingDialog.this.setSize(d.width + dx, d.height + dy);
                    FloatingDialog.this.validate();
                    break;
                }
                case 8: {
                    FloatingDialog.this.invalidate();
                    FloatingDialog.this.setSize(d.width, d.height + dy);
                    FloatingDialog.this.validate();
                    break;
                }
                case 10: {
                    FloatingDialog.this.invalidate();
                    bounds.x += dx;
                    bounds.width -= dx;
                    bounds.height += dy;
                    FloatingDialog.this.setBounds(bounds);
                    FloatingDialog.this.validate();
                    break;
                }
                case 2: {
                    FloatingDialog.this.invalidate();
                    bounds.x += dx;
                    bounds.width -= dx;
                    FloatingDialog.this.setBounds(bounds);
                    FloatingDialog.this.validate();
                }
            }
            this.lastPoint = p;
        }

        public void mouseReleased(MouseEvent e) {
            this.dragType = -1;
        }

        public void mousePressed(MouseEvent e) {
            this.dragType = 0;
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), FloatingDialog.this.getContentPane());
            if (p.y < FloatingDialog.this.title.getY() + FloatingDialog.this.title.getHeight()) {
                this.dragType |= 1;
            }
            if (p.x < FloatingDialog.this.left.getX() + FloatingDialog.this.left.getWidth()) {
                this.dragType |= 2;
            }
            if (p.x >= FloatingDialog.this.right.getX()) {
                this.dragType |= 4;
            }
            if (p.y >= FloatingDialog.this.bottom.getY()) {
                this.dragType |= 8;
            }
            this.lastPoint = e.getPoint();
            SwingUtilities.convertPointToScreen(this.lastPoint, e.getComponent());
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), FloatingDialog.this.getContentPane());
            int dragType = 0;
            if (p.y < FloatingDialog.this.title.getY() + FloatingDialog.this.title.getHeight()) {
                dragType |= 1;
            }
            if (p.x < FloatingDialog.this.left.getX() + FloatingDialog.this.left.getWidth()) {
                dragType |= 2;
            }
            if (p.x >= FloatingDialog.this.right.getX()) {
                dragType |= 4;
            }
            if (p.y >= FloatingDialog.this.bottom.getY()) {
                dragType |= 8;
            }
            Cursor c = null;
            switch (dragType) {
                case 0: {
                    c = Cursor.getDefaultCursor();
                    break;
                }
                case 1: {
                    c = Cursor.getPredefinedCursor(13);
                    break;
                }
                case 3: {
                    c = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 5: {
                    c = Cursor.getPredefinedCursor(7);
                    break;
                }
                case 4: {
                    c = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 12: {
                    c = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 8: {
                    c = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 10: {
                    c = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 2: {
                    c = Cursor.getPredefinedCursor(10);
                }
            }
            if (!e.getComponent().getCursor().equals(c)) {
                e.getComponent().setCursor(c);
            }
        }
    }
}

