/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.toolbars;

import com.vlsolutions.swing.toolbars.ToolBarButtonBorder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.border.Border;

public class ToolBarPanelBorder
implements Border {
    public static final int TOP_PANEL = 0;
    public static final int LEFT_PANEL = 1;
    public static final int BOTTOM_PANEL = 2;
    public static final int RIGHT_PANEL = 3;
    private static Image borderImage = new ImageIcon(ToolBarButtonBorder.class.getResource("toolbarpanelborder.png")).getImage();
    static int borderWidth = borderImage.getWidth(null);
    static int borderHeight = borderImage.getHeight(null);
    private Insets insets;
    private int panelPosition;

    public ToolBarPanelBorder() {
        this(0);
    }

    public ToolBarPanelBorder(int panelPosition) {
        this.panelPosition = panelPosition;
        switch (panelPosition) {
            case 0: {
                this.insets = new Insets(1, 1, 4, 1);
                break;
            }
            case 1: {
                this.insets = new Insets(1, 1, 1, 4);
                break;
            }
            case 2: {
                this.insets = new Insets(4, 1, 1, 1);
                break;
            }
            case 3: {
                this.insets = new Insets(1, 4, 1, 1);
            }
        }
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int x, int y, int w, int h) {
        switch (this.panelPosition) {
            case 0: {
                graphics.drawImage(borderImage, x, y + h - 5, x + w, y + h, 5, borderHeight - 5, borderWidth - 5, borderHeight, null);
                break;
            }
            case 1: {
                graphics.drawImage(borderImage, x + w - 5, y, x + w, y + h, borderWidth - 5, 5, borderWidth, borderHeight - 5, null);
                break;
            }
            case 2: {
                graphics.drawImage(borderImage, x, y, x + w, y + 5, 5, 0, borderHeight - 5, 5, null);
                break;
            }
            case 3: {
                graphics.drawImage(borderImage, x, y, x + 5, y + h, 0, 5, 5, borderHeight - 5, null);
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }
}

