/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.exts.encoder;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.PropertyInject;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.processor.EventProcessor;
import org.fcrepo.camel.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRouter.class);
    private static final String REPOSITORY = "http://fedora.info/definitions/v4/repository#";
    public static final String SERIALIZATION_PATH = "CamelSerializationPath";
    public final List<Predicate> uriFilter = ProcessorUtils.tokenizePropertyPlaceholder((CamelContext)this.getContext(), (String)"{{filter.containers}}", (String)",").stream().map(uri -> PredicateBuilder.or((Predicate)this.header("CamelFcrepoUri").startsWith((Object)this.constant(uri + "/")), (Predicate)this.header("CamelFcrepoUri").isEqualTo((Object)this.constant(uri)))).collect(Collectors.toList());
    @PropertyInject(value="{{fcrepo.base.uri}}")
    public String FCREPO_BASEURI;

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#").add("fedora", REPOSITORY);
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((RouteDefinition)((RouteDefinition)this.from("{{input.stream}}").routeId("PandoraEncoder").process((Processor)new EventProcessor())).process(exchange -> {
            String uri = (String)exchange.getIn().getHeader("CamelFcrepoUri", (Object)"", String.class);
            exchange.getIn().setHeader(SERIALIZATION_PATH, (Object)URI.create(uri).getPath());
        })).filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(this.uriFilter))).to("direct:get");
        ((ExpressionNode)this.from("{{reserialization.stream}}").routeId("PandoraReEncoder").filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(this.uriFilter))).process(exchange -> {
            String uri = (String)exchange.getIn().getHeader("CamelFcrepoUri", (Object)"", String.class);
            exchange.getIn().setHeader(SERIALIZATION_PATH, (Object)URI.create(uri).getPath());
        })).to("direct:get");
        ((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ProcessorDefinition)((ProcessorDefinition)((ExpressionNode)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((RouteDefinition)this.from("direct:get").routeId("ImageGet").removeHeaders("CamelHttp*")).setHeader("CamelHttpMethod").constant((Object)"HEAD")).setHeader("CamelHttpUri").header("CamelFcrepoUri")).to("http4://localhost")).log(LoggingLevel.INFO, LOGGER, "Encoder Processing ${headers[CamelHttpUri]}")).filter(this.header("Content-Type").isEqualTo((Object)"image/tiff")).removeHeaders("CamelHttp*")).setHeader("CamelHttpMethod").constant((Object)"GET")).setHeader("CamelHttpUri").simple("{{image.processor.uri}}")).process(ex -> {
            String uri = (String)ex.getIn().getHeader("CamelFcrepoUri", String.class);
            String path = uri.replace(this.FCREPO_BASEURI, "") + "/svc:image";
            ex.getIn().setHeader("CamelHttpPath", (Object)path);
        })).log(LoggingLevel.INFO, LOGGER, "Encoder Replacing " + this.FCREPO_BASEURI + " in ${headers[CamelFcrepoUri]}")).log(LoggingLevel.INFO, LOGGER, "Encoder Requesting ${headers[CamelHttpPath]}")).to("http4://localhost")).process(ex -> {
            String resource = (String)ex.getIn().getHeader("CamelHttpPath", String.class);
            String jp2ext = resource.replace("tif/svc:image", "jp2");
            String filename = jp2ext.replace("/", "_");
            ex.getIn().setHeader("CamelFileName", (Object)filename);
        })).log(LoggingLevel.INFO, LOGGER, "Filename is: ${headers[CamelFileName]}")).to("file://{{serialization.binaries}}");
    }
}

