/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ansi;

import cool.scx.common.os.OSHelper;
import cool.scx.common.os.OSInfo;
import cool.scx.common.os.OSType;
import cool.scx.ffm.FFMProxy;
import cool.scx.ffm.mapper.IntMapper;
import java.lang.foreign.MemorySegment;

class AnsiHelper {
    static final int STD_OUTPUT_HANDLE = -11;
    static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;

    AnsiHelper() {
    }

    static void enableWindows10AnsiSupport() {
        Kernel32 KERNEL32 = (Kernel32)FFMProxy.ffmProxy((String)"kernel32", Kernel32.class);
        MemorySegment hOut = KERNEL32.GetStdHandle(-11);
        IntMapper lpModeMapper = new IntMapper();
        KERNEL32.GetConsoleMode(hOut, lpModeMapper);
        KERNEL32.SetConsoleMode(hOut, lpModeMapper.getValue() | 4);
    }

    static boolean checkAnsiSupport() {
        OSInfo osInfo = OSHelper.getOSInfo();
        if (osInfo.type() != OSType.WINDOWS) {
            return true;
        }
        if (!osInfo.version().startsWith("10") && !osInfo.version().startsWith("11")) {
            return false;
        }
        try {
            AnsiHelper.enableWindows10AnsiSupport();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static interface Kernel32 {
        public MemorySegment GetStdHandle(int var1);

        public boolean GetConsoleMode(MemorySegment var1, IntMapper var2);

        public boolean SetConsoleMode(MemorySegment var1, long var2);
    }
}

