/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ansi;

import cool.scx.common.os.OSHelper;
import cool.scx.common.os.OSInfo;
import cool.scx.common.os.OSType;
import cool.scx.ffm.mapper.IntMapper;
import cool.scx.ffm.platform.win32.Kernel32;
import java.lang.foreign.MemorySegment;

class AnsiHelper {
    static final int STD_OUTPUT_HANDLE = -11;
    static final int ENABLE_VIRTUAL_TERMINAL_PROCESSING = 4;

    AnsiHelper() {
    }

    static void enableWindows10AnsiSupport() {
        MemorySegment hOut = Kernel32.KERNEL32.GetStdHandle(-11);
        IntMapper lpModeMapper = new IntMapper();
        Kernel32.KERNEL32.GetConsoleMode(hOut, lpModeMapper);
        Kernel32.KERNEL32.SetConsoleMode(hOut, (long)(lpModeMapper.getValue() | 4));
    }

    static boolean checkAnsiSupport() {
        OSInfo osInfo = OSHelper.getOSInfo();
        if (osInfo.type() != OSType.WINDOWS) {
            return true;
        }
        if (!osInfo.version().startsWith("10") && !osInfo.version().startsWith("11")) {
            return false;
        }
        try {
            AnsiHelper.enableWindows10AnsiSupport();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

