/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ansi;

import cool.scx.ansi.AnsiElement;
import cool.scx.ansi.AnsiStyle;

record AnsiItem(Object value, AnsiElement[] elements) {
    private static final String ENCODE_START = "\u001b[";
    private static final char ENCODE_JOIN = ';';
    private static final char ENCODE_END = 'm';

    private void appendAnsiElements(StringBuilder sb) {
        boolean isFirst = true;
        for (AnsiElement element : this.elements) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(';');
            }
            sb.append(element.code());
        }
    }

    public void buildEnabled(StringBuilder sb) {
        if (this.elements.length == 0) {
            this.buildDisabled(sb);
            return;
        }
        sb.append(ENCODE_START);
        this.appendAnsiElements(sb);
        sb.append('m');
        sb.append(this.value);
        sb.append(ENCODE_START);
        sb.append(AnsiStyle.RESET.code());
        sb.append('m');
    }

    public void buildDisabled(StringBuilder sb) {
        sb.append(this.value);
    }
}

