/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ansi;

import cool.scx.ansi.Ansi8BitBackground;
import cool.scx.ansi.Ansi8BitColor;
import cool.scx.ansi.AnsiBackground;
import cool.scx.ansi.AnsiColor;
import cool.scx.ansi.AnsiElement;
import cool.scx.ansi.AnsiHelper;
import cool.scx.ansi.AnsiItem;
import cool.scx.ansi.AnsiStyle;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class Ansi {
    private static final boolean SUPPORTED = AnsiHelper.checkAnsiSupport();
    private final List<AnsiItem> items = new ArrayList<AnsiItem>();

    public static Ansi ansi() {
        return new Ansi();
    }

    private static AnsiElement[] filterAnsiElement(AnsiElement ... elements) {
        if (elements.length < 2) {
            return elements;
        }
        AnsiElement ansiColor = null;
        AnsiElement ansiBackground = null;
        EnumSet<AnsiStyle> ansiStyleSet = EnumSet.noneOf(AnsiStyle.class);
        block5: for (AnsiElement element : elements) {
            Objects.requireNonNull(element);
            int n = 0;
            block6: while (true) {
                AnsiElement ansiElement;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnsiColor.class, Ansi8BitColor.class, AnsiBackground.class, Ansi8BitBackground.class, AnsiStyle.class}, (AnsiElement)ansiElement, n)) {
                    case 0: 
                    case 1: {
                        if (!(ansiElement instanceof AnsiColor) && !(ansiElement instanceof Ansi8BitColor)) {
                            n = 2;
                            continue block6;
                        }
                        ansiColor = element;
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        if (!(ansiElement instanceof AnsiBackground) && !(ansiElement instanceof Ansi8BitBackground)) {
                            n = 4;
                            continue block6;
                        }
                        ansiBackground = element;
                        continue block5;
                    }
                    case 4: {
                        AnsiStyle ansiStyle = (AnsiStyle)ansiElement;
                        ansiStyleSet.add(ansiStyle);
                        continue block5;
                    }
                    default: {
                        continue block5;
                    }
                }
                break;
            }
        }
        int size = (ansiColor != null ? 1 : 0) + (ansiBackground != null ? 1 : 0) + ansiStyleSet.size();
        AnsiElement[] result = new AnsiElement[size];
        int index = 0;
        if (ansiColor != null) {
            result[index] = ansiColor;
            ++index;
        }
        if (ansiBackground != null) {
            result[index] = ansiBackground;
            ++index;
        }
        for (AnsiStyle element : ansiStyleSet) {
            result[index] = element;
            ++index;
        }
        return result;
    }

    private static AnsiElement[] filterAnsiElement(AnsiElement[] a1, AnsiElement a2) {
        if (a1.length == 0) {
            return new AnsiElement[]{a2};
        }
        AnsiElement[] result = new AnsiElement[a1.length + 1];
        System.arraycopy(a1, 0, result, 0, a1.length);
        result[a1.length] = a2;
        return Ansi.filterAnsiElement(result);
    }

    public Ansi add(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements)));
        return this;
    }

    public Ansi defaultColor(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.DEFAULT)));
        return this;
    }

    public Ansi black(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BLACK)));
        return this;
    }

    public Ansi red(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.RED)));
        return this;
    }

    public Ansi green(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.GREEN)));
        return this;
    }

    public Ansi yellow(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.YELLOW)));
        return this;
    }

    public Ansi blue(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BLUE)));
        return this;
    }

    public Ansi magenta(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.MAGENTA)));
        return this;
    }

    public Ansi cyan(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.CYAN)));
        return this;
    }

    public Ansi white(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.WHITE)));
        return this;
    }

    public Ansi brightBlack(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_BLACK)));
        return this;
    }

    public Ansi brightRed(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_RED)));
        return this;
    }

    public Ansi brightGreen(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_GREEN)));
        return this;
    }

    public Ansi brightYellow(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_YELLOW)));
        return this;
    }

    public Ansi brightBlue(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_BLUE)));
        return this;
    }

    public Ansi brightMagenta(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_MAGENTA)));
        return this;
    }

    public Ansi brightCyan(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_CYAN)));
        return this;
    }

    public Ansi brightWhite(Object o, AnsiElement ... ansiElements) {
        this.items.add(new AnsiItem(o, Ansi.filterAnsiElement(ansiElements, (AnsiElement)AnsiColor.BRIGHT_WHITE)));
        return this;
    }

    public Ansi ln() {
        return this.add(System.lineSeparator(), new AnsiElement[0]);
    }

    public void print(boolean useAnsi) {
        System.out.print(this.toString(useAnsi));
    }

    public void print() {
        this.print(true);
    }

    public void println(boolean useAnsi) {
        this.ln().print(useAnsi);
    }

    public void println() {
        this.println(true);
    }

    public String toString(boolean useAnsi) {
        StringBuilder sb = new StringBuilder();
        if (SUPPORTED && useAnsi) {
            for (AnsiItem i : this.items) {
                i.buildEnabled(sb);
            }
        } else {
            for (AnsiItem i : this.items) {
                i.buildDisabled(sb);
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(true);
    }
}

