/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.x.redirect;

import cool.scx.ansi.Ansi;
import cool.scx.ansi.AnsiElement;
import cool.scx.app.Scx;
import cool.scx.app.ScxModule;
import cool.scx.http.routing.Router;
import cool.scx.http.x.XHttpServer;
import cool.scx.http.x.XHttpServerOptions;
import cool.scx.web.vo.Redirection;
import java.util.function.Consumer;

public class RedirectModule
extends ScxModule {
    private static final System.Logger logger = System.getLogger(RedirectModule.class.getName());
    private final int port;

    public RedirectModule() {
        this(80);
    }

    public RedirectModule(int port) {
        this.port = port;
    }

    public static void startRedirect(int port) {
        Router router = Router.of();
        router.route().handler(c -> {
            String oldURI = c.request().uri().toString();
            String newURI = "https" + oldURI.substring(4);
            Redirection.ofTemporary((String)newURI).accept(c);
        });
        XHttpServer httpServer = new XHttpServer(new XHttpServerOptions().port(port));
        httpServer.onRequest((Consumer)router);
        try {
            httpServer.start();
            Ansi.ansi().brightMagenta((Object)("\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f http -> https, \u7aef\u53e3\u53f7 : " + httpServer.localAddress().getPort() + " !!!"), new AnsiElement[0]).println();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25 !!! ", (Throwable)e);
        }
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }

    public void start(Scx scx) {
        if (scx.scxOptions().isHttpsEnabled()) {
            RedirectModule.startRedirect(this.port);
        }
    }
}

