/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.x.crud;

import cool.scx.app.ScxAppContext;
import cool.scx.app.base.BaseModel;
import cool.scx.app.base.BaseModelService;
import cool.scx.app.x.crud.CRUDHelper;
import cool.scx.app.x.crud.CRUDListParam;
import cool.scx.app.x.crud.CRUDUpdateParam;
import cool.scx.data.field_filter.FieldFilter;
import cool.scx.data.query.Logic;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.QueryOption;
import cool.scx.http.method.HttpMethod;
import cool.scx.web.annotation.FromBody;
import cool.scx.web.annotation.FromPath;
import cool.scx.web.annotation.ScxRoute;
import cool.scx.web.vo.BaseVo;
import cool.scx.web.vo.Result;
import java.util.List;
import java.util.Map;

public class BaseCRUDController<T extends BaseModelService> {
    protected final T service;

    public BaseCRUDController(T service) {
        this.service = service;
    }

    public BaseCRUDController() {
        this.service = (BaseModelService)ScxAppContext.getBean(CRUDHelper.findBaseModelServiceClass(this.getClass()));
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo list(CRUDListParam crudListParam) {
        Query query = crudListParam.getQuery();
        FieldFilter selectFilter = crudListParam.getFieldFilter();
        List list = this.service.find(query, selectFilter);
        long total = this.service.count(query);
        return Result.ok().put("items", (Object)list).put("total", (Object)total);
    }

    @ScxRoute(value=":id", methods={HttpMethod.GET})
    public BaseVo info(@FromPath Long id) {
        BaseModel info = this.service.get(id.longValue());
        return Result.ok((Object)info);
    }

    @ScxRoute(value="", methods={HttpMethod.POST})
    public BaseVo add(@FromBody(useAllBody=true) Map<String, Object> saveModel) {
        Object realObject = CRUDHelper.mapToBaseModel(saveModel, this.service.entityClass());
        BaseModel savedModel = this.service.add(realObject);
        return Result.ok((Object)savedModel);
    }

    @ScxRoute(value="", methods={HttpMethod.PUT})
    public BaseVo update(CRUDUpdateParam crudUpdateParam) {
        Object realObject = crudUpdateParam.getBaseModel(this.service.entityClass());
        FieldFilter updateFilter = crudUpdateParam.getUpdateFilter(this.service.entityClass(), this.service.dao().tableInfo());
        BaseModel updatedModel = this.service.update(realObject, updateFilter);
        return Result.ok((Object)updatedModel);
    }

    @ScxRoute(value="", methods={HttpMethod.DELETE})
    public BaseVo delete(CRUDListParam crudListParam) {
        Query query = crudListParam.getQuery();
        long size = this.service.delete(query);
        return Result.ok((Object)size);
    }

    @ScxRoute(value="check-unique/:fieldName", methods={HttpMethod.POST})
    public BaseVo checkUnique(@FromPath String fieldName, @FromBody Object value, @FromBody(required=false) Long id) {
        CRUDHelper.checkFieldName(this.service.entityClass(), fieldName);
        Logic query = QueryBuilder.and((Object[])new Object[0]).eq(fieldName, value, new QueryOption[0]).ne("id", (Object)id, new QueryOption[]{QueryOption.SKIP_IF_NULL});
        boolean isUnique = this.service.count((Query)query) == 0L;
        return Result.ok().put("isUnique", (Object)isUnique);
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo count(CRUDListParam crudListParam) {
        Query query = crudListParam.getQuery();
        long total = this.service.count(query);
        return Result.ok((Object)total);
    }
}

