/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.x.fss;

import cool.scx.app.annotation.ScxService;
import cool.scx.app.base.BaseModelService;
import cool.scx.app.x.fss.FSSHelper;
import cool.scx.app.x.fss.FSSObject;
import cool.scx.common.util.FileUtils;
import cool.scx.data.build_control.BuildControl;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.Where;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;

@ScxService
public class FSSObjectService
extends BaseModelService<FSSObject> {
    public List<FSSObject> findFSSObjectListByHash(String fileHash) {
        return this.find(QueryBuilder.query().where((Where)QueryBuilder.eq((String)"fileHash", (Object)fileHash, (BuildControl[])new BuildControl[0])).orderBy(new OrderBy[]{QueryBuilder.desc((String)"uploadTime", (BuildControl[])new BuildControl[0])}));
    }

    public long countByHash(String fileHash) {
        return this.count(QueryBuilder.query().where((Where)QueryBuilder.eq((String)"fileHash", (Object)fileHash, (BuildControl[])new BuildControl[0])));
    }

    public FSSObject findByFSSObjectID(String fssObjectID) {
        return (FSSObject)this.get(QueryBuilder.query().where((Where)QueryBuilder.eq((String)"fssObjectID", (Object)fssObjectID, (BuildControl[])new BuildControl[0])));
    }

    public List<FSSObject> findByFSSObjectIDs(List<String> fssObjectIDs) {
        return this.find((Query)QueryBuilder.in((String)"fssObjectID", fssObjectIDs, (BuildControl[])new BuildControl[0]));
    }

    public void delete(String fssObjectID) throws IOException {
        FSSObject needDeleteFile = this.findByFSSObjectID(fssObjectID);
        if (needDeleteFile != null) {
            long count = this.countByHash(needDeleteFile.fileHash);
            if (count <= 1L) {
                Path filePath = FSSHelper.getPhysicalFilePath(needDeleteFile);
                try {
                    FileUtils.delete((Path)filePath.getParent());
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            this.delete(new long[]{needDeleteFile.id});
        }
    }
}

