/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.x.crud;

import cool.scx.app.base.BaseModel;
import cool.scx.app.base.BaseModelService;
import cool.scx.app.x.crud.BaseCRUDController;
import cool.scx.app.x.crud.exception.UnknownFieldNameException;
import cool.scx.data.jdbc.annotation.NoColumn;
import cool.scx.http.exception.BadRequestException;
import cool.scx.object.ScxObject;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeInfo;
import java.lang.reflect.Field;
import java.util.Map;

public final class CRUDHelper {
    private static final System.Logger logger = System.getLogger(CRUDHelper.class.getName());

    public static <B extends BaseModel> B mapToBaseModel(Map<String, Object> map, Class<B> baseModelClass) {
        try {
            return (B)((BaseModel)ScxObject.convertValue(map, baseModelClass));
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "\u5c06 Map \u8f6c\u6362\u4e3a BaseModel \u65f6\u53d1\u751f\u5f02\u5e38 : ", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
    }

    public static String checkFieldName(Class<?> modelClass, String fieldName) throws UnknownFieldNameException {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new UnknownFieldNameException(fieldName);
            }
        }
        catch (Exception e) {
            throw new UnknownFieldNameException(fieldName);
        }
        return fieldName;
    }

    static Class<? extends BaseModelService<?>> findBaseModelServiceClass(Class<?> baseCRUDControllerClass) {
        ClassInfo superClass = ((ClassInfo)ScxReflect.typeOf(baseCRUDControllerClass)).findSuperType(BaseCRUDController.class);
        if (superClass != null) {
            TypeInfo boundType = superClass.bindings().get(0);
            if (boundType != null) {
                return boundType.rawClass();
            }
            throw new IllegalArgumentException(baseCRUDControllerClass.getName() + " : \u5fc5\u987b\u8bbe\u7f6e\u6cdb\u578b\u53c2\u6570 !!!");
        }
        throw new IllegalArgumentException(baseCRUDControllerClass.getName() + " : \u5fc5\u987b\u7ee7\u627f\u81ea BaseCRUDController !!!");
    }
}

