/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.x.static_server;

import cool.scx.app.ScxApp;
import cool.scx.app.ScxAppModule;
import cool.scx.app.x.static_server.ConvertStaticServerHandler;
import cool.scx.app.x.static_server.StaticServer;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.functional.ScxConsumer;
import cool.scx.http.routing.Router;
import cool.scx.http.routing.handler.StaticHandler;
import java.util.List;
import java.util.stream.Collectors;

public class StaticServerModule
extends ScxAppModule {
    private static final System.Logger logger = System.getLogger(StaticServerModule.class.getName());

    private static void registerStaticServerHandler(Router router, List<StaticServer> staticServers) {
        for (StaticServer staticServer : staticServers) {
            router.route().path(staticServer.location()).handler((ScxConsumer)new StaticHandler(staticServer.root()));
        }
    }

    public void start(ScxApp scx) {
        List staticServers = (List)scx.scxConfig().get("static-servers", (ScxConfigValueHandler)new ConvertStaticServerHandler(scx.scxEnvironment()));
        logger.log(System.Logger.Level.DEBUG, "\u9759\u6001\u8d44\u6e90\u670d\u52a1\u5668 -->  {0}", staticServers.stream().map(StaticServer::location).collect(Collectors.joining(", ", "[", "]")));
        StaticServerModule.registerStaticServerHandler((Router)scx.scxHttpRouter(), staticServers);
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }
}

