/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.x.redirect;

import cool.scx.ansi.Ansi;
import cool.scx.ansi.AnsiElement;
import cool.scx.app.ScxApp;
import cool.scx.app.ScxAppModule;
import cool.scx.http.uri.ScxURI;
import cool.scx.http.uri.ScxURIWritable;
import cool.scx.http.x.HttpServer;
import cool.scx.web.vo.Redirection;

public class RedirectModule
extends ScxAppModule {
    private static final System.Logger logger = System.getLogger(RedirectModule.class.getName());
    private final int port;

    public RedirectModule() {
        this(80);
    }

    public RedirectModule(int port) {
        this.port = port;
    }

    public static void startRedirect(int port) {
        HttpServer httpServer = new HttpServer();
        httpServer.onRequest(request -> {
            ScxURI oldURI = request.uri();
            ScxURIWritable newURI = ScxURI.of((ScxURI)oldURI).scheme("https");
            Redirection.ofTemporary((String)newURI.encode(true)).handle(request.response());
        });
        try {
            httpServer.start(port);
            Ansi.ansi().brightMagenta((Object)("\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f http -> https, \u7aef\u53e3\u53f7 : " + httpServer.localAddress().getPort() + " !!!"), new AnsiElement[0]).println();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25 !!! ", (Throwable)e);
        }
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }

    public void start(ScxApp scx) {
        if (scx.scxOptions().isHttpsEnabled()) {
            RedirectModule.startRedirect(this.port);
        }
    }
}

