/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import cool.scx.app.Scx;
import cool.scx.app.ScxModule;
import cool.scx.app.ScxOptions;
import cool.scx.app.annotation.Scheduled;
import cool.scx.app.annotation.ScheduledList;
import cool.scx.app.annotation.ScxService;
import cool.scx.app.base.BaseModel;
import cool.scx.app.base.BaseModelService;
import cool.scx.app.enumeration.ScxAppFeature;
import cool.scx.common.util.ClassUtils;
import cool.scx.common.util.ConsoleUtils;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.config.handler.AppRootHandler;
import cool.scx.config.handler.ConvertValueHandler;
import cool.scx.config.handler.DefaultValueHandler;
import cool.scx.data.jdbc.annotation.Table;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.dialect.DialectSelector;
import cool.scx.jdbc.spy.Spy;
import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.recorder.ConsoleRecorder;
import cool.scx.logging.recorder.FileRecorder;
import cool.scx.net.tls.TLS;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ReflectFactory;
import cool.scx.scheduling.ScxScheduling;
import cool.scx.web.annotation.ScxRoute;
import cool.scx.web.annotation.ScxWebSocketRoute;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public final class ScxHelper {
    private static final List<Class<? extends Annotation>> beanFilterAnnotation = List.of(ScxRoute.class, Table.class, ScxService.class, ScxWebSocketRoute.class);

    static Path findRootPathByScxModule(Class<? extends ScxModule> c) throws IOException {
        URI classSource = ClassUtils.getCodeSource(c);
        Path classSourcePath = Path.of(classSource);
        boolean isJar = ClassUtils.isJar((Path)classSourcePath);
        return isJar ? classSourcePath.getParent() : classSourcePath;
    }

    static List<Class<?>> findClassListByScxModule(Class<? extends ScxModule> c) throws IOException {
        URI classSource = ClassUtils.getCodeSource(c);
        Path classSourcePath = Path.of(classSource);
        boolean isJar = ClassUtils.isJar((Path)classSourcePath);
        Class[] allClassList = isJar ? ClassUtils.findClassListFromJar((URI)classSource) : ClassUtils.findClassListFromPath((Path)classSourcePath, (ClassLoader)c.getClassLoader());
        String basePackage = c.getPackageName();
        return List.of(ClassUtils.filterByBasePackage((Class[])allClassList, (String)basePackage));
    }

    public static boolean isBeanClass(Class<?> clazz) {
        for (Class<? extends Annotation> a : beanFilterAnnotation) {
            if (clazz.getAnnotation(a) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isScxBaseModelClass(Class<?> c) {
        return c.isAnnotationPresent(Table.class) && ClassUtils.isInstantiableClass(c) && BaseModel.class.isAssignableFrom(c);
    }

    public static boolean isScxBaseModelServiceClass(Class<?> c) {
        ParameterizedType t;
        Type type;
        return c.isAnnotationPresent(ScxService.class) && ClassUtils.isNormalClass(c) && (type = c.getGenericSuperclass()) instanceof ParameterizedType && (t = (ParameterizedType)type).getActualTypeArguments().length == 1;
    }

    public static <Entity extends BaseModel> Class<Entity> findBaseModelServiceEntityClass(Class<?> baseModelServiceClass) {
        ClassInfo superClass = ReflectFactory.getClassInfo(baseModelServiceClass).findSuperType(BaseModelService.class);
        if (superClass != null) {
            JavaType boundType = superClass.type().getBindings().getBoundType(0);
            if (boundType != null) {
                return boundType.getRawClass();
            }
            throw new IllegalArgumentException(baseModelServiceClass.getName() + " : \u5fc5\u987b\u8bbe\u7f6e\u6cdb\u578b\u53c2\u6570 !!!");
        }
        throw new IllegalArgumentException(baseModelServiceClass.getName() + " : \u5fc5\u987b\u7ee7\u627f\u81ea BaseModelService !!!");
    }

    static boolean isUseNewPort(int port) {
        String result;
        do {
            String errMessage = "*******************************************************\n*                                                     *\n*         \u7aef\u53e3\u53f7 [ %s ] \u5df2\u88ab\u5360\u7528, \u662f\u5426\u91c7\u7528\u65b0\u7aef\u53e3\u53f7 ?       *\n*                                                     *\n*                [Y]es    |    [N]o                   *\n*                                                     *\n*******************************************************\n";
            System.err.printf(errMessage + System.lineSeparator(), port);
            result = ConsoleUtils.readLine().trim();
            if (!"Y".equalsIgnoreCase(result)) continue;
            return true;
        } while (!"N".equalsIgnoreCase(result));
        String ignoreMessage = "*******************************************\n*                                         *\n*     N \u7aef\u53e3\u53f7\u88ab\u5360\u7528!!! \u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25 !!!      *\n*                                         *\n*******************************************\n";
        System.err.println(ignoreMessage);
        System.exit(-1);
        return false;
    }

    static DataSource initDataSource(ScxOptions scxOptions, ScxFeatureConfig scxFeatureConfig) {
        String url = scxOptions.dataSourceUrl();
        Dialect dialect = DialectSelector.findDialect((String)url);
        DataSource realDataSource = dialect.createDataSource(url, scxOptions.dataSourceUsername(), scxOptions.dataSourcePassword(), scxOptions.dataSourceParameters());
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDataSource(realDataSource);
        HikariDataSource hikariDataSource = new HikariDataSource(hikariConfig);
        return (Boolean)scxFeatureConfig.get((ScxFeature)ScxAppFeature.USE_SPY) != false ? Spy.wrap((DataSource)hikariDataSource) : hikariDataSource;
    }

    static ScxModule[] initScxModuleMetadataList(ScxModule[] scxModules) {
        if (scxModules == null || Arrays.stream(scxModules).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("Modules must not be empty !!!");
        }
        return scxModules;
    }

    static DefaultListableBeanFactory initBeanFactory(ScxModule[] modules, ScxFeatureConfig scxFeatureConfig) {
        Class[] beanClass;
        DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory();
        AutowiredAnnotationBeanPostProcessor beanPostProcessor = new AutowiredAnnotationBeanPostProcessor();
        beanPostProcessor.setBeanFactory((BeanFactory)beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)beanPostProcessor);
        beanFactory.setAllowCircularReferences(((Boolean)scxFeatureConfig.get((ScxFeature)ScxAppFeature.ALLOW_CIRCULAR_REFERENCES)).booleanValue());
        for (Class c2 : beanClass = (Class[])Arrays.stream(modules).flatMap(c -> c.classList().stream()).filter(ScxHelper::isBeanClass).toArray(Class[]::new)) {
            AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(c2);
            beanFactory.registerBeanDefinition(c2.getName(), (BeanDefinition)beanDefinition);
        }
        return beanFactory;
    }

    public static void startAnnotationScheduled(DefaultListableBeanFactory beanFactory) {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
            Object bean = beanFactory.getBean(beanDefinitionName);
            ClassInfo classInfo = ReflectFactory.getClassInfo(bean.getClass());
            block1: for (MethodInfo method : classInfo.methods()) {
                if (method.accessModifier() != AccessModifier.PUBLIC) continue;
                List scheduledList = Arrays.stream(method.annotations()).flatMap(c -> {
                    Annotation annotation = c;
                    Objects.requireNonNull(annotation);
                    Annotation selector0$temp = annotation;
                    int index$1 = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Scheduled.class, ScheduledList.class}, (Annotation)selector0$temp, index$1)) {
                        case 0 -> {
                            Scheduled s = (Scheduled)selector0$temp;
                            yield Stream.of(s);
                        }
                        case 1 -> {
                            ScheduledList f = (ScheduledList)selector0$temp;
                            yield Stream.of(f.value());
                        }
                        default -> Stream.of(new Scheduled[0]);
                    };
                }).toList();
                for (Scheduled scheduled : scheduledList) {
                    if (method.parameters().length != 0) {
                        Scx.logger.log(System.Logger.Level.ERROR, "\u88ab Scheduled \u6ce8\u89e3\u6807\u8bc6\u7684\u65b9\u6cd5\u4e0d\u53ef\u4ee5\u6709\u53c2\u6570 Class [{0}] , Method [{1}]", classInfo.type().getRawClass().getName(), method.name());
                        continue block1;
                    }
                    if (method.isStatic()) {
                        ScxScheduling.cron().expression(scheduled.cron()).start(c -> {
                            try {
                                method.method().invoke(null, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        });
                        continue;
                    }
                    ScxScheduling.cron().expression(scheduled.cron()).start(c -> {
                        try {
                            method.method().invoke(bean, new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
            }
        }
    }

    static void dataSourceExceptionHandler(Exception e) {
        block1: {
            String result;
            do {
                String errMessage = "**************************************************************\n*                                                            *\n*           X \u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25 !!! \u662f\u5426\u5ffd\u7565\u9519\u8bef\u5e76\u7ee7\u7eed\u8fd0\u884c ?            *\n*                                                            *\n*        [Y] \u5ffd\u7565\u9519\u8bef\u5e76\u7ee7\u7eed\u8fd0\u884c    |     [N] \u9000\u51fa\u7a0b\u5e8f              *\n*                                                            *\n**************************************************************\n";
                System.err.println(errMessage);
                result = ConsoleUtils.readLine().trim();
                if (!"Y".equalsIgnoreCase(result)) continue;
                String ignoreMessage = "*******************************************\n*                                         *\n*       N \u6570\u636e\u6e90\u94fe\u63a5\u9519\u8bef,\u7528\u6237\u5df2\u5ffd\u7565 !!!         *\n*                                         *\n*******************************************\n";
                System.err.println(ignoreMessage);
                break block1;
            } while (!"N".equalsIgnoreCase(result));
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static void initScxLoggerFactory(ScxConfig scxConfig, ScxEnvironment scxEnvironment) {
        ScxHelper.initScxLoggerFactory0(scxConfig, scxEnvironment);
        scxConfig.onChange((oldValue, newValue) -> ScxHelper.initScxLoggerFactory0(scxConfig, scxEnvironment));
    }

    static void initScxLoggerFactory0(ScxConfig scxConfig, ScxEnvironment scxEnvironment) {
        System.Logger.Level defaultLevel = ScxHelper.toLevel((String)scxConfig.get("scx.logging.default.level", String.class));
        LoggingType defaultType = ScxHelper.toType((String)scxConfig.get("scx.logging.default.type", String.class));
        Path defaultStoredDirectory = (Path)scxConfig.get("scx.logging.default.stored-directory", (ScxConfigValueHandler)AppRootHandler.of((ScxEnvironment)scxEnvironment, (String)"AppRoot:logs"));
        Boolean defaultStackTrace = (Boolean)scxConfig.get("scx.logging.default.stack-trace", (ScxConfigValueHandler)DefaultValueHandler.of((Object)false));
        ScxLoggerConfig defaultConfig = ScxLoggerFactory.rootConfig().clearRecorders();
        defaultConfig.setLevel(defaultLevel);
        if (defaultType == LoggingType.CONSOLE || defaultType == LoggingType.BOTH) {
            defaultConfig.addRecorder(new ScxLogRecorder[]{new ConsoleRecorder()});
        }
        if (defaultType == LoggingType.FILE || defaultType == LoggingType.BOTH) {
            defaultConfig.addRecorder(new ScxLogRecorder[]{new FileRecorder(defaultStoredDirectory)});
        }
        defaultConfig.setStackTrace(defaultStackTrace);
        List loggers = (List)scxConfig.get("scx.logging.loggers", (ScxConfigValueHandler)ConvertValueHandler.of((TypeReference)new TypeReference<List<Map<String, String>>>(){}));
        if (loggers != null) {
            for (Map logger : loggers) {
                String name = (String)logger.get("name");
                if (!StringUtils.notBlank((String)name)) continue;
                System.Logger.Level level = ScxHelper.toLevel((String)logger.get("level"));
                LoggingType type = ScxHelper.toType((String)logger.get("type"));
                Path storedDirectory = StringUtils.notBlank((String)((String)logger.get("stored-directory"))) ? scxEnvironment.getPathByAppRoot((String)logger.get("stored-directory")) : null;
                Boolean stackTrace = (Boolean)ObjectUtils.convertValue(logger.get("stack-trace"), Boolean.class);
                ScxLoggerConfig config = new ScxLoggerConfig();
                config.setLevel(level);
                if (type == LoggingType.CONSOLE || type == LoggingType.BOTH) {
                    config.addRecorder(new ScxLogRecorder[]{new ConsoleRecorder()});
                }
                if (type == LoggingType.FILE || type == LoggingType.BOTH) {
                    config.addRecorder(new ScxLogRecorder[]{new FileRecorder(storedDirectory != null ? storedDirectory : defaultStoredDirectory)});
                }
                config.setStackTrace(stackTrace);
                ScxLoggerFactory.setConfig((String)name, (ScxLoggerConfig)config);
            }
        }
    }

    private static System.Logger.Level toLevel(String levelName) {
        String s;
        Objects.requireNonNull(levelName, "levelName \u4e0d\u80fd\u4e3a\u7a7a !!!");
        return switch (s = levelName.trim().toUpperCase()) {
            case "OFF", "O" -> System.Logger.Level.OFF;
            case "ERROR", "E" -> System.Logger.Level.ERROR;
            case "WARN", "WARNING", "W" -> System.Logger.Level.WARNING;
            case "INFO", "I" -> System.Logger.Level.INFO;
            case "DEBUG", "D" -> System.Logger.Level.DEBUG;
            case "TRACE", "T" -> System.Logger.Level.TRACE;
            case "ALL", "A" -> System.Logger.Level.ALL;
            default -> null;
        };
    }

    private static LoggingType toType(String loggingTypeName) {
        String s;
        Objects.requireNonNull(loggingTypeName, "loggingTypeName \u4e0d\u80fd\u4e3a\u7a7a !!!");
        return switch (s = loggingTypeName.trim().toUpperCase()) {
            case "CONSOLE", "C" -> LoggingType.CONSOLE;
            case "FILE", "F" -> LoggingType.FILE;
            case "BOTH", "B" -> LoggingType.BOTH;
            default -> null;
        };
    }

    public static Tls getTls(Path path, String password) {
        TLS tls = new TLS(path, password);
        TlsConfig.Builder builder = Tls.builder();
        builder.sslContext(tls.sslContext());
        return builder.build();
    }

    private static enum LoggingType {
        CONSOLE,
        FILE,
        BOTH;

    }
}

