/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app;

import cool.scx.ansi.Ansi;
import cool.scx.ansi.AnsiElement;
import cool.scx.common.exception.ScxExceptionHelper;
import cool.scx.common.util.NetUtils;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxConfigValueHandler;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.handler.AppRootHandler;
import cool.scx.config.handler.DecryptValueHandler;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class ScxOptions {
    private final int port;
    private final String allowedOrigin;
    private final String dataSourceUrl;
    private final String dataSourceUsername;
    private final String dataSourcePassword;
    private final String[] dataSourceParameters;
    private final boolean httpsEnabled;
    private final Path sslPath;
    private final String sslPassword;
    private final Path templateRoot;

    public ScxOptions(ScxConfig scxConfig, ScxEnvironment scxEnvironment, String appKey) {
        this.port = (Integer)scxConfig.getOrDefault("scx.port", (Object)8080);
        this.allowedOrigin = (String)scxConfig.getOrDefault("scx.allowed-origin", (Object)"*");
        this.templateRoot = (Path)scxConfig.get("scx.template.root", (ScxConfigValueHandler)AppRootHandler.of((ScxEnvironment)scxEnvironment, (String)"AppRoot:/c/"));
        this.httpsEnabled = (Boolean)scxConfig.getOrDefault("scx.https.enabled", (Object)false);
        this.sslPath = (Path)scxConfig.get("scx.https.ssl-path", (ScxConfigValueHandler)AppRootHandler.of((ScxEnvironment)scxEnvironment));
        this.sslPassword = (String)scxConfig.get("scx.https.ssl-password", (ScxConfigValueHandler)DecryptValueHandler.of((String)appKey));
        this.dataSourceUrl = (String)scxConfig.getOrDefault("scx.data-source.url", (Object)"");
        this.dataSourceUsername = (String)scxConfig.get("scx.data-source.username", String.class);
        this.dataSourcePassword = (String)scxConfig.get("scx.data-source.password", (ScxConfigValueHandler)DecryptValueHandler.of((String)appKey));
        this.dataSourceParameters = (String[])scxConfig.getOrDefault("scx.data-source.parameters", (Object)new String[0]);
    }

    public String dataSourceUrl() {
        return this.dataSourceUrl;
    }

    public String[] dataSourceParameters() {
        return this.dataSourceParameters;
    }

    public String dataSourceUsername() {
        return this.dataSourceUsername;
    }

    public String dataSourcePassword() {
        return this.dataSourcePassword;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public int port() {
        return this.port;
    }

    public Path sslPath() {
        return this.sslPath;
    }

    public String sslPassword() {
        return this.sslPassword;
    }

    public Path templateRoot() {
        return this.templateRoot;
    }

    public String allowedOrigin() {
        return this.allowedOrigin;
    }

    public void printInfo() {
        Ansi.ansi().green((Object)("Y \u670d\u52a1\u5668 IP \u5730\u5740                       \t -->\t " + Arrays.stream((InetAddress[])ScxExceptionHelper.ignore(() -> NetUtils.getLocalIPAddress(c -> c instanceof Inet4Address), (Object)new InetAddress[0])).map(InetAddress::getHostAddress).collect(Collectors.joining(", ", "[", "]"))), new AnsiElement[0]).ln().green((Object)("Y \u7aef\u53e3\u53f7                               \t -->\t " + this.port), new AnsiElement[0]).ln().green((Object)("Y \u5141\u8bb8\u7684\u8bf7\u6c42\u6e90                         \t -->\t " + this.allowedOrigin), new AnsiElement[0]).ln().green((Object)("Y \u6a21\u677f\u6839\u76ee\u5f55                           \t -->\t " + this.templateRoot.toString()), new AnsiElement[0]).ln().green((Object)("Y \u662f\u5426\u5f00\u542f https                       \t -->\t " + (this.httpsEnabled ? "\u662f" : "\u5426")), new AnsiElement[0]).ln().green((Object)("Y \u8bc1\u4e66\u8def\u5f84                            \t -->\t " + (this.sslPath != null ? this.sslPath.toString() : "")), new AnsiElement[0]).ln().green((Object)"Y \u8bc1\u4e66\u5bc6\u7801                            \t -->\t *****", new AnsiElement[0]).ln().green((Object)("Y \u6570\u636e\u6e90 URL                           \t -->\t " + this.dataSourceUrl), new AnsiElement[0]).ln().green((Object)("Y \u6570\u636e\u6e90 \u7528\u6237\u540d                        \t -->\t " + this.dataSourceUsername), new AnsiElement[0]).ln().green((Object)"Y \u6570\u636e\u6e90 \u8fde\u63a5\u5bc6\u7801                      \t -->\t *****", new AnsiElement[0]).ln().green((Object)("Y \u6570\u636e\u6e90 \u8fde\u63a5\u53c2\u6570                      \t -->\t " + Arrays.toString(this.dataSourceParameters)), new AnsiElement[0]).println();
    }
}

