/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app;

import cool.scx.app.ScxApp;
import cool.scx.app.ScxAppModule;
import cool.scx.app.enumeration.ScxAppFeature;
import cool.scx.common.util.StringUtils;
import cool.scx.config.ScxConfig;
import cool.scx.config.ScxConfigSource;
import cool.scx.config.ScxEnvironment;
import cool.scx.config.ScxFeature;
import cool.scx.config.ScxFeatureConfig;
import cool.scx.config.source.ArgsConfigSource;
import cool.scx.config.source.JsonFileConfigSource;
import cool.scx.config.source.MapConfigSource;
import cool.scx.http.x.XHttpServerOptions;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ScxAppBuilder {
    private static final Map<String, Object> DEFAULT_CONFIG_MAP = ScxAppBuilder.initDefaultConfigMap();
    private static final String DEFAULT_APP_KEY = "SCX-123456";
    private static final String DEFAULT_SCX_CONFIG_PATH = "AppRoot:scx-config.json";
    private final List<ScxAppModule> scxModules = new ArrayList<ScxAppModule>();
    private final ScxFeatureConfig scxFeatureConfig = new ScxFeatureConfig();
    private final List<ScxConfigSource> scxConfigSources = new ArrayList<ScxConfigSource>();
    private String[] args = new String[0];
    private Class<?> mainClass = null;
    private String appKey = "SCX-123456";
    private Object defaultHttpServerOptions = null;

    private static Map<String, Object> initDefaultConfigMap() {
        LinkedHashMap<String, Object> tempMap = new LinkedHashMap<String, Object>();
        tempMap.put("scx.port", 8080);
        tempMap.put("scx.tombstone", false);
        tempMap.put("scx.allowed-origin", "*");
        tempMap.put("scx.template.root", "AppRoot:/c/");
        tempMap.put("scx.static-servers", new Object[0]);
        tempMap.put("scx.https.enabled", false);
        tempMap.put("scx.https.ssl-path", "");
        tempMap.put("scx.https.ssl-password", "");
        tempMap.put("scx.data-source.host", "127.0.0.1");
        tempMap.put("scx.data-source.port", 3306);
        tempMap.put("scx.data-source.database", "");
        tempMap.put("scx.data-source.username", "");
        tempMap.put("scx.data-source.password", "");
        tempMap.put("scx.data-source.parameters", new HashSet());
        tempMap.put("scx.logging.default.level", "ERROR");
        tempMap.put("scx.logging.default.type", "CONSOLE");
        tempMap.put("scx.logging.default.stored-directory", "AppRoot:logs");
        tempMap.put("scx.logging.default.stack-trace", false);
        return tempMap;
    }

    private static String checkAppKey(String appKey) {
        if (StringUtils.isBlank((String)appKey)) {
            throw new IllegalArgumentException("AppKey cannot be set empty");
        }
        if (DEFAULT_APP_KEY.equals(appKey)) {
            System.err.println("\u6ce8\u610f!!! \u672a\u8bbe\u7f6e APP_KEY ,\u5df2\u91c7\u7528 DEFAULT_APP_KEY , \u8fd9\u662f\u975e\u5e38\u4e0d\u5b89\u5168\u7684 , \u5efa\u8bae\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u7684 APP_KEY !!!");
        }
        return appKey;
    }

    private static Class<?> checkMainClass(Class<?> mainClass) {
        if (mainClass == null) {
            throw new IllegalArgumentException("MainClass must not be empty !!! ");
        }
        return mainClass;
    }

    private static String getScxConfigPath(String[] args) {
        ScxConfig scxConfig = new ScxConfig(new ScxConfigSource[]{ArgsConfigSource.of((String[])args)});
        String scxConfigPath = (String)scxConfig.get("scx.config.path", String.class);
        return scxConfigPath != null ? scxConfigPath : DEFAULT_SCX_CONFIG_PATH;
    }

    public ScxApp run() {
        return this.build().run();
    }

    public ScxApp build() {
        ScxAppBuilder.checkAppKey(this.appKey);
        ScxAppBuilder.checkMainClass(this.mainClass);
        ScxEnvironment scxEnvironment = new ScxEnvironment(this.mainClass);
        MapConfigSource defaultMapConfigSource = MapConfigSource.of(DEFAULT_CONFIG_MAP);
        JsonFileConfigSource defaultJsonFileConfigSource = JsonFileConfigSource.of((Path)scxEnvironment.getPathByAppRoot(ScxAppBuilder.getScxConfigPath(this.args)));
        ArgsConfigSource defaultArgsConfigSource = ArgsConfigSource.of((String[])this.args);
        this.scxConfigSources.add((ScxConfigSource)defaultMapConfigSource);
        this.scxConfigSources.add((ScxConfigSource)defaultJsonFileConfigSource);
        this.scxConfigSources.add((ScxConfigSource)defaultArgsConfigSource);
        ScxConfig scxConfig = new ScxConfig((ScxConfigSource[])this.scxConfigSources.toArray(ScxConfigSource[]::new));
        return new ScxApp(scxEnvironment, this.appKey, this.scxFeatureConfig, scxConfig, (ScxAppModule[])this.scxModules.toArray(ScxAppModule[]::new), this.defaultHttpServerOptions);
    }

    public ScxAppBuilder addModule(ScxAppModule ... modules) {
        this.scxModules.addAll(Arrays.asList(modules));
        return this;
    }

    public ScxAppBuilder setMainClass(Class<?> mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public ScxAppBuilder setAppKey(String appKey) {
        this.appKey = appKey;
        return this;
    }

    public ScxAppBuilder setArgs(String ... args) {
        this.args = args;
        return this;
    }

    public ScxAppBuilder configure(ScxAppFeature scxFeature, boolean state) {
        this.scxFeatureConfig.set((ScxFeature)scxFeature, (Object)state);
        return this;
    }

    public ScxAppBuilder setDefaultHttpServerOptions(XHttpServerOptions options) {
        this.defaultHttpServerOptions = options;
        return this;
    }
}

