/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.base;

import cool.scx.app.ScxAppContext;
import cool.scx.app.ScxAppHelper;
import cool.scx.app.base.BaseModel;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyBuilder;
import cool.scx.data.jdbc.JDBCRepository;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.QueryOption;
import cool.scx.jdbc.sql.SQL;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class BaseModelService<Entity extends BaseModel> {
    protected final Class<Entity> entityClass;
    private JDBCRepository<Entity> dao;

    public BaseModelService() {
        this.entityClass = ScxAppHelper.findBaseModelServiceEntityClass(this.getClass());
    }

    public BaseModelService(Class<Entity> entityClass) {
        this.entityClass = entityClass;
    }

    private static FieldPolicy updateFilterProcessor(FieldPolicy updateFilter) {
        return updateFilter.excluded(new String[]{"id", "createdDate", "updatedDate"});
    }

    public final Entity add(Entity entity) {
        return this.add(entity, FieldPolicyBuilder.includedAll());
    }

    public Entity add(Entity entity, FieldPolicy updateFilter) {
        Long newID = this.dao().add(entity, BaseModelService.updateFilterProcessor(updateFilter));
        return newID != null ? (Entity)this.get(newID) : null;
    }

    public Entity add(FieldPolicy updateFilter) {
        Long newID = (Long)this.dao().add(BaseModelService.updateFilterProcessor(updateFilter));
        return newID != null ? (Entity)this.get(newID) : null;
    }

    public final List<Long> add(Collection<Entity> entityList) {
        return this.add(entityList, FieldPolicyBuilder.includedAll());
    }

    public List<Long> add(Collection<Entity> entityList, FieldPolicy updateFilter) {
        return this.dao().add(entityList, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final List<Entity> find() {
        return this.find(QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    public final List<Entity> find(FieldPolicy selectFilter) {
        return this.find(QueryBuilder.query(), selectFilter);
    }

    public final List<Entity> find(Query query) {
        return this.find(query, FieldPolicyBuilder.includedAll());
    }

    public List<Entity> find(Query query, FieldPolicy selectFilter) {
        return this.dao().find(query, selectFilter).list();
    }

    public final void find(Consumer<Entity> consumer) {
        this.find(QueryBuilder.query(), FieldPolicyBuilder.includedAll(), consumer);
    }

    public final void find(FieldPolicy selectFilter, Consumer<Entity> consumer) {
        this.find(QueryBuilder.query(), selectFilter, consumer);
    }

    public final void find(Query query, Consumer<Entity> consumer) {
        this.find(query, FieldPolicyBuilder.includedAll(), consumer);
    }

    public void find(Query query, FieldPolicy selectFilter, Consumer<Entity> consumer) {
        this.dao().find(query, selectFilter).forEach(consumer);
    }

    public final List<Entity> find(long ... ids) {
        return this.find((Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (QueryOption[])new QueryOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (QueryOption[])new QueryOption[0])));
    }

    public final Entity get(long id) {
        return this.get(id, FieldPolicyBuilder.includedAll());
    }

    public final Entity get(long id, FieldPolicy selectFilter) {
        return this.get((Query)QueryBuilder.eq((String)"id", (Object)id, (QueryOption[])new QueryOption[0]), selectFilter);
    }

    public final Entity get(Query query) {
        return this.get(query, FieldPolicyBuilder.includedAll());
    }

    public Entity get(Query query, FieldPolicy selectFilter) {
        return (Entity)((BaseModel)this.dao().find(query, selectFilter).first());
    }

    public final <T> List<T> findAs(Class<T> resultClass) {
        return this.findAs(resultClass, QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    public final <T> List<T> findAs(Class<T> resultClass, FieldPolicy selectFilter) {
        return this.findAs(resultClass, QueryBuilder.query(), selectFilter);
    }

    public final <T> List<T> findAs(Class<T> resultClass, Query query) {
        return this.findAs(resultClass, query, FieldPolicyBuilder.includedAll());
    }

    public <T> List<T> findAs(Class<T> resultClass, Query query, FieldPolicy selectFilter) {
        return this.dao().find(query, selectFilter).list(resultClass);
    }

    public final <T> void findAs(Class<T> resultClass, Consumer<T> consumer) {
        this.findAs(resultClass, QueryBuilder.query(), FieldPolicyBuilder.includedAll(), consumer);
    }

    public final <T> void findAs(Class<T> resultClass, FieldPolicy selectFilter, Consumer<T> consumer) {
        this.findAs(resultClass, QueryBuilder.query(), selectFilter, consumer);
    }

    public final <T> void findAs(Class<T> resultClass, Query query, Consumer<T> consumer) {
        this.findAs(resultClass, query, FieldPolicyBuilder.includedAll(), consumer);
    }

    public <T> void findAs(Class<T> resultClass, Query query, FieldPolicy selectFilter, Consumer<T> consumer) {
        this.dao().find(query, selectFilter).forEach(consumer, resultClass);
    }

    public final <T> List<T> findAs(Class<T> resultClass, long ... ids) {
        return this.findAs(resultClass, (Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (QueryOption[])new QueryOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (QueryOption[])new QueryOption[0])));
    }

    public final <T> T getAs(Class<T> resultClass, long id) {
        return this.getAs(resultClass, id, FieldPolicyBuilder.includedAll());
    }

    public final <T> T getAs(Class<T> resultClass, long id, FieldPolicy selectFilter) {
        return this.getAs(resultClass, (Query)QueryBuilder.eq((String)"id", (Object)id, (QueryOption[])new QueryOption[0]), selectFilter);
    }

    public final <T> T getAs(Class<T> resultClass, Query query) {
        return this.getAs(resultClass, query, FieldPolicyBuilder.includedAll());
    }

    public <T> T getAs(Class<T> resultClass, Query query, FieldPolicy selectFilter) {
        return (T)this.dao().find(query, selectFilter).first(resultClass);
    }

    public final Entity update(Entity entity) {
        return this.update(entity, FieldPolicyBuilder.includedAll());
    }

    public final Entity update(Entity entity, FieldPolicy updateFilter) {
        if (((BaseModel)entity).id == null) {
            throw new RuntimeException("\u6839\u636e id \u66f4\u65b0\u65f6 id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.update(entity, updateFilter, (Query)QueryBuilder.eq((String)"id", (Object)((BaseModel)entity).id, (QueryOption[])new QueryOption[0]));
        return this.get(((BaseModel)entity).id);
    }

    public final long update(Entity entity, Query query) {
        return this.update(entity, FieldPolicyBuilder.includedAll(), query);
    }

    public long update(Entity entity, FieldPolicy updateFilter, Query query) {
        return this.dao().update(entity, BaseModelService.updateFilterProcessor(updateFilter), query);
    }

    public long update(FieldPolicy updateFilter, Query query) {
        return this.dao().update(BaseModelService.updateFilterProcessor(updateFilter), query);
    }

    public final long delete(long ... ids) {
        if (ids.length == 0) {
            throw new IllegalArgumentException("\u5f85\u5220\u9664\u7684 ids \u6570\u91cf\u81f3\u5c11\u4e3a 1 \u4e2a");
        }
        return this.delete((Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (QueryOption[])new QueryOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (QueryOption[])new QueryOption[0])));
    }

    public long delete(Query query) {
        return this.dao().delete(query);
    }

    public final long count() {
        return this.dao().find().count();
    }

    public final long count(Query query) {
        return this.dao().find(query).count();
    }

    public final JDBCRepository<Entity> dao() {
        if (this.dao == null) {
            this.dao = new JDBCRepository(this.entityClass, ScxAppContext.jdbcContext());
        }
        return this.dao;
    }

    public final Class<Entity> entityClass() {
        return this.entityClass;
    }

    public final SQL buildListSQL(Query query, FieldPolicy selectFilter) {
        return this.dao().buildSelectSQL(query, selectFilter);
    }

    public final SQL buildGetSQL(Query query, FieldPolicy selectFilter) {
        return this.dao().buildGetSQL(query, selectFilter);
    }

    public final SQL buildListSQLWithAlias(Query query, FieldPolicy selectFilter) {
        return this.dao().buildSelectSQLWithAlias(query, selectFilter);
    }

    public final SQL buildGetSQLWithAlias(Query query, FieldPolicy selectFilter) {
        return this.dao().buildGetSQLWithAlias(query, selectFilter);
    }
}

