/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.app.base;

import cool.scx.app.ScxAppContext;
import cool.scx.app.ScxAppHelper;
import cool.scx.app.base.BaseModel;
import cool.scx.data.Finder;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyBuilder;
import cool.scx.data.jdbc.JDBCRepository;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.QueryOption;
import cool.scx.jdbc.sql.SQL;
import java.util.Collection;
import java.util.List;

public class BaseModelService<Entity extends BaseModel> {
    protected final Class<Entity> entityClass;
    private JDBCRepository<Entity> dao;

    public BaseModelService() {
        this.entityClass = ScxAppHelper.findBaseModelServiceEntityClass(this.getClass());
    }

    public BaseModelService(Class<Entity> entityClass) {
        this.entityClass = entityClass;
    }

    private static FieldPolicy updateFilterProcessor(FieldPolicy updateFilter) {
        return updateFilter.excluded(new String[]{"id", "createdDate", "updatedDate"});
    }

    public final Entity add(Entity entity) {
        return this.add(entity, FieldPolicyBuilder.includedAll());
    }

    public final Entity add(FieldPolicy updateFilter) {
        return (Entity)this.add((BaseModel)null, updateFilter);
    }

    public Entity add(Entity entity, FieldPolicy updateFilter) {
        Long newID = this.dao().add(entity, BaseModelService.updateFilterProcessor(updateFilter));
        return newID != null ? (Entity)this.get(newID) : null;
    }

    public final List<Long> add(Collection<Entity> entityList) {
        return this.add(entityList, FieldPolicyBuilder.includedAll());
    }

    public List<Long> add(Collection<Entity> entityList, FieldPolicy updateFilter) {
        return this.dao().add(entityList, BaseModelService.updateFilterProcessor(updateFilter));
    }

    public final List<Entity> find() {
        return this.find(QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    public final List<Entity> find(FieldPolicy selectFilter) {
        return this.find(QueryBuilder.query(), selectFilter);
    }

    public final List<Entity> find(Query query) {
        return this.find(query, FieldPolicyBuilder.includedAll());
    }

    public List<Entity> find(Query query, FieldPolicy selectFilter) {
        return this.dao().find(query, selectFilter);
    }

    public final List<Entity> find(long ... ids) {
        return this.find((Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (QueryOption[])new QueryOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (QueryOption[])new QueryOption[0])));
    }

    public final Entity get(long id) {
        return this.get(id, FieldPolicyBuilder.includedAll());
    }

    public final Entity get(long id, FieldPolicy selectFilter) {
        return this.get((Query)QueryBuilder.eq((String)"id", (Object)id, (QueryOption[])new QueryOption[0]), selectFilter);
    }

    public final Entity get(Query query) {
        return this.get(query, FieldPolicyBuilder.includedAll());
    }

    public Entity get(Query query, FieldPolicy selectFilter) {
        return (Entity)((BaseModel)this.dao().get(query, selectFilter));
    }

    public final Finder<Entity> finder() {
        return this.finder(QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    public final Finder<Entity> finder(FieldPolicy selectFilter) {
        return this.finder(QueryBuilder.query(), selectFilter);
    }

    public final Finder<Entity> finder(Query query) {
        return this.finder(query, FieldPolicyBuilder.includedAll());
    }

    public Finder<Entity> finder(Query query, FieldPolicy selectFilter) {
        return this.dao().finder(query, selectFilter);
    }

    public final Entity update(Entity entity) {
        return this.update(entity, FieldPolicyBuilder.includedAll());
    }

    public final Entity update(Entity entity, FieldPolicy updateFilter) {
        if (((BaseModel)entity).id == null) {
            throw new RuntimeException("\u6839\u636e id \u66f4\u65b0\u65f6 id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.update(entity, updateFilter, (Query)QueryBuilder.eq((String)"id", (Object)((BaseModel)entity).id, (QueryOption[])new QueryOption[0]));
        return this.get(((BaseModel)entity).id);
    }

    public final long update(Entity entity, Query query) {
        return this.update(entity, FieldPolicyBuilder.includedAll(), query);
    }

    public final long update(FieldPolicy updateFilter, Query query) {
        return this.update(null, updateFilter, query);
    }

    public long update(Entity entity, FieldPolicy updateFilter, Query query) {
        return this.dao().update(entity, BaseModelService.updateFilterProcessor(updateFilter), query);
    }

    public final long delete(long ... ids) {
        if (ids.length == 0) {
            throw new IllegalArgumentException("\u5f85\u5220\u9664\u7684 ids \u6570\u91cf\u81f3\u5c11\u4e3a 1 \u4e2a");
        }
        return this.delete((Query)(ids.length == 1 ? QueryBuilder.eq((String)"id", (Object)ids[0], (QueryOption[])new QueryOption[0]) : QueryBuilder.in((String)"id", (Object)ids, (QueryOption[])new QueryOption[0])));
    }

    public long delete(Query query) {
        return this.dao().delete(query);
    }

    public final long count() {
        return this.dao().count();
    }

    public final long count(Query query) {
        return this.dao().count(query);
    }

    public final JDBCRepository<Entity> dao() {
        if (this.dao == null) {
            this.dao = new JDBCRepository(this.entityClass, ScxAppContext.jdbcContext());
        }
        return this.dao;
    }

    public final Class<Entity> entityClass() {
        return this.entityClass;
    }

    public final SQL buildListSQL(Query query, FieldPolicy selectFilter) {
        return this.dao().buildSelectSQL(query, selectFilter);
    }

    public final SQL buildGetSQL(Query query, FieldPolicy selectFilter) {
        return this.dao().buildGetSQL(query, selectFilter);
    }

    public final SQL buildListSQLWithAlias(Query query, FieldPolicy selectFilter) {
        return this.dao().buildSelectSQLWithAlias(query, selectFilter);
    }

    public final SQL buildGetSQLWithAlias(Query query, FieldPolicy selectFilter) {
        return this.dao().buildGetSQLWithAlias(query, selectFilter);
    }
}

